/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.WorkweekConfig;
import java.util.List;
import java.util.Objects;

public class ListWorkweekConfigsResponse {
    private HttpContext httpContext;
    private final List<WorkweekConfig> workweekConfigs;
    private final String cursor;
    private final List<Error> errors;

    @JsonCreator
    public ListWorkweekConfigsResponse(@JsonProperty(value="workweek_configs") List<WorkweekConfig> workweekConfigs, @JsonProperty(value="cursor") String cursor, @JsonProperty(value="errors") List<Error> errors) {
        this.workweekConfigs = workweekConfigs;
        this.cursor = cursor;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="workweek_configs")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<WorkweekConfig> getWorkweekConfigs() {
        return this.workweekConfigs;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.workweekConfigs, this.cursor, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListWorkweekConfigsResponse)) {
            return false;
        }
        ListWorkweekConfigsResponse other = (ListWorkweekConfigsResponse)obj;
        return Objects.equals(this.workweekConfigs, other.workweekConfigs) && Objects.equals(this.cursor, other.cursor) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "ListWorkweekConfigsResponse [workweekConfigs=" + this.workweekConfigs + ", cursor=" + this.cursor + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().workweekConfigs(this.getWorkweekConfigs()).cursor(this.getCursor()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<WorkweekConfig> workweekConfigs;
        private String cursor;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder workweekConfigs(List<WorkweekConfig> workweekConfigs) {
            this.workweekConfigs = workweekConfigs;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public ListWorkweekConfigsResponse build() {
            ListWorkweekConfigsResponse model = new ListWorkweekConfigsResponse(this.workweekConfigs, this.cursor, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

