/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.LoyaltyAccountExpiringPointDeadline;
import com.squareup.square.models.LoyaltyAccountMapping;
import java.util.List;
import java.util.Objects;

public class LoyaltyAccount {
    private final String id;
    private final String programId;
    private final Integer balance;
    private final Integer lifetimePoints;
    private final String customerId;
    private final String enrolledAt;
    private final String createdAt;
    private final String updatedAt;
    private final LoyaltyAccountMapping mapping;
    private final List<LoyaltyAccountExpiringPointDeadline> expiringPointDeadlines;

    @JsonCreator
    public LoyaltyAccount(@JsonProperty(value="program_id") String programId, @JsonProperty(value="id") String id, @JsonProperty(value="balance") Integer balance, @JsonProperty(value="lifetime_points") Integer lifetimePoints, @JsonProperty(value="customer_id") String customerId, @JsonProperty(value="enrolled_at") String enrolledAt, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="updated_at") String updatedAt, @JsonProperty(value="mapping") LoyaltyAccountMapping mapping, @JsonProperty(value="expiring_point_deadlines") List<LoyaltyAccountExpiringPointDeadline> expiringPointDeadlines) {
        this.id = id;
        this.programId = programId;
        this.balance = balance;
        this.lifetimePoints = lifetimePoints;
        this.customerId = customerId;
        this.enrolledAt = enrolledAt;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.mapping = mapping;
        this.expiringPointDeadlines = expiringPointDeadlines;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="program_id")
    public String getProgramId() {
        return this.programId;
    }

    @JsonGetter(value="balance")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getBalance() {
        return this.balance;
    }

    @JsonGetter(value="lifetime_points")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getLifetimePoints() {
        return this.lifetimePoints;
    }

    @JsonGetter(value="customer_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCustomerId() {
        return this.customerId;
    }

    @JsonGetter(value="enrolled_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEnrolledAt() {
        return this.enrolledAt;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonGetter(value="mapping")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public LoyaltyAccountMapping getMapping() {
        return this.mapping;
    }

    @JsonGetter(value="expiring_point_deadlines")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<LoyaltyAccountExpiringPointDeadline> getExpiringPointDeadlines() {
        return this.expiringPointDeadlines;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.programId, this.balance, this.lifetimePoints, this.customerId, this.enrolledAt, this.createdAt, this.updatedAt, this.mapping, this.expiringPointDeadlines);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LoyaltyAccount)) {
            return false;
        }
        LoyaltyAccount other = (LoyaltyAccount)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.programId, other.programId) && Objects.equals(this.balance, other.balance) && Objects.equals(this.lifetimePoints, other.lifetimePoints) && Objects.equals(this.customerId, other.customerId) && Objects.equals(this.enrolledAt, other.enrolledAt) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt) && Objects.equals(this.mapping, other.mapping) && Objects.equals(this.expiringPointDeadlines, other.expiringPointDeadlines);
    }

    public String toString() {
        return "LoyaltyAccount [programId=" + this.programId + ", id=" + this.id + ", balance=" + this.balance + ", lifetimePoints=" + this.lifetimePoints + ", customerId=" + this.customerId + ", enrolledAt=" + this.enrolledAt + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", mapping=" + this.mapping + ", expiringPointDeadlines=" + this.expiringPointDeadlines + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.programId).id(this.getId()).balance(this.getBalance()).lifetimePoints(this.getLifetimePoints()).customerId(this.getCustomerId()).enrolledAt(this.getEnrolledAt()).createdAt(this.getCreatedAt()).updatedAt(this.getUpdatedAt()).mapping(this.getMapping()).expiringPointDeadlines(this.getExpiringPointDeadlines());
        return builder;
    }

    public static class Builder {
        private String programId;
        private String id;
        private Integer balance;
        private Integer lifetimePoints;
        private String customerId;
        private String enrolledAt;
        private String createdAt;
        private String updatedAt;
        private LoyaltyAccountMapping mapping;
        private List<LoyaltyAccountExpiringPointDeadline> expiringPointDeadlines;

        public Builder(String programId) {
            this.programId = programId;
        }

        public Builder programId(String programId) {
            this.programId = programId;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder balance(Integer balance) {
            this.balance = balance;
            return this;
        }

        public Builder lifetimePoints(Integer lifetimePoints) {
            this.lifetimePoints = lifetimePoints;
            return this;
        }

        public Builder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder enrolledAt(String enrolledAt) {
            this.enrolledAt = enrolledAt;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder mapping(LoyaltyAccountMapping mapping) {
            this.mapping = mapping;
            return this;
        }

        public Builder expiringPointDeadlines(List<LoyaltyAccountExpiringPointDeadline> expiringPointDeadlines) {
            this.expiringPointDeadlines = expiringPointDeadlines;
            return this;
        }

        public LoyaltyAccount build() {
            return new LoyaltyAccount(this.programId, this.id, this.balance, this.lifetimePoints, this.customerId, this.enrolledAt, this.createdAt, this.updatedAt, this.mapping, this.expiringPointDeadlines);
        }
    }
}

