/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class LoyaltyEventAccumulatePoints {
    private final String loyaltyProgramId;
    private final Integer points;
    private final String orderId;

    @JsonCreator
    public LoyaltyEventAccumulatePoints(@JsonProperty(value="loyalty_program_id") String loyaltyProgramId, @JsonProperty(value="points") Integer points, @JsonProperty(value="order_id") String orderId) {
        this.loyaltyProgramId = loyaltyProgramId;
        this.points = points;
        this.orderId = orderId;
    }

    @JsonGetter(value="loyalty_program_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLoyaltyProgramId() {
        return this.loyaltyProgramId;
    }

    @JsonGetter(value="points")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getPoints() {
        return this.points;
    }

    @JsonGetter(value="order_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getOrderId() {
        return this.orderId;
    }

    public int hashCode() {
        return Objects.hash(this.loyaltyProgramId, this.points, this.orderId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LoyaltyEventAccumulatePoints)) {
            return false;
        }
        LoyaltyEventAccumulatePoints other = (LoyaltyEventAccumulatePoints)obj;
        return Objects.equals(this.loyaltyProgramId, other.loyaltyProgramId) && Objects.equals(this.points, other.points) && Objects.equals(this.orderId, other.orderId);
    }

    public String toString() {
        return "LoyaltyEventAccumulatePoints [loyaltyProgramId=" + this.loyaltyProgramId + ", points=" + this.points + ", orderId=" + this.orderId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().loyaltyProgramId(this.getLoyaltyProgramId()).points(this.getPoints()).orderId(this.getOrderId());
        return builder;
    }

    public static class Builder {
        private String loyaltyProgramId;
        private Integer points;
        private String orderId;

        public Builder loyaltyProgramId(String loyaltyProgramId) {
            this.loyaltyProgramId = loyaltyProgramId;
            return this;
        }

        public Builder points(Integer points) {
            this.points = points;
            return this;
        }

        public Builder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public LoyaltyEventAccumulatePoints build() {
            return new LoyaltyEventAccumulatePoints(this.loyaltyProgramId, this.points, this.orderId);
        }
    }
}

