/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class LoyaltyEventCreateReward {
    private final String loyaltyProgramId;
    private final String rewardId;
    private final int points;

    @JsonCreator
    public LoyaltyEventCreateReward(@JsonProperty(value="loyalty_program_id") String loyaltyProgramId, @JsonProperty(value="points") int points, @JsonProperty(value="reward_id") String rewardId) {
        this.loyaltyProgramId = loyaltyProgramId;
        this.rewardId = rewardId;
        this.points = points;
    }

    @JsonGetter(value="loyalty_program_id")
    public String getLoyaltyProgramId() {
        return this.loyaltyProgramId;
    }

    @JsonGetter(value="reward_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getRewardId() {
        return this.rewardId;
    }

    @JsonGetter(value="points")
    public int getPoints() {
        return this.points;
    }

    public int hashCode() {
        return Objects.hash(this.loyaltyProgramId, this.rewardId, this.points);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LoyaltyEventCreateReward)) {
            return false;
        }
        LoyaltyEventCreateReward other = (LoyaltyEventCreateReward)obj;
        return Objects.equals(this.loyaltyProgramId, other.loyaltyProgramId) && Objects.equals(this.rewardId, other.rewardId) && Objects.equals(this.points, other.points);
    }

    public String toString() {
        return "LoyaltyEventCreateReward [loyaltyProgramId=" + this.loyaltyProgramId + ", points=" + this.points + ", rewardId=" + this.rewardId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.loyaltyProgramId, this.points).rewardId(this.getRewardId());
        return builder;
    }

    public static class Builder {
        private String loyaltyProgramId;
        private int points;
        private String rewardId;

        public Builder(String loyaltyProgramId, int points) {
            this.loyaltyProgramId = loyaltyProgramId;
            this.points = points;
        }

        public Builder loyaltyProgramId(String loyaltyProgramId) {
            this.loyaltyProgramId = loyaltyProgramId;
            return this;
        }

        public Builder points(int points) {
            this.points = points;
            return this;
        }

        public Builder rewardId(String rewardId) {
            this.rewardId = rewardId;
            return this;
        }

        public LoyaltyEventCreateReward build() {
            return new LoyaltyEventCreateReward(this.loyaltyProgramId, this.points, this.rewardId);
        }
    }
}

