/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class LoyaltyEventExpirePoints {
    private final String loyaltyProgramId;
    private final int points;

    @JsonCreator
    public LoyaltyEventExpirePoints(@JsonProperty(value="loyalty_program_id") String loyaltyProgramId, @JsonProperty(value="points") int points) {
        this.loyaltyProgramId = loyaltyProgramId;
        this.points = points;
    }

    @JsonGetter(value="loyalty_program_id")
    public String getLoyaltyProgramId() {
        return this.loyaltyProgramId;
    }

    @JsonGetter(value="points")
    public int getPoints() {
        return this.points;
    }

    public int hashCode() {
        return Objects.hash(this.loyaltyProgramId, this.points);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LoyaltyEventExpirePoints)) {
            return false;
        }
        LoyaltyEventExpirePoints other = (LoyaltyEventExpirePoints)obj;
        return Objects.equals(this.loyaltyProgramId, other.loyaltyProgramId) && Objects.equals(this.points, other.points);
    }

    public String toString() {
        return "LoyaltyEventExpirePoints [loyaltyProgramId=" + this.loyaltyProgramId + ", points=" + this.points + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.loyaltyProgramId, this.points);
        return builder;
    }

    public static class Builder {
        private String loyaltyProgramId;
        private int points;

        public Builder(String loyaltyProgramId, int points) {
            this.loyaltyProgramId = loyaltyProgramId;
            this.points = points;
        }

        public Builder loyaltyProgramId(String loyaltyProgramId) {
            this.loyaltyProgramId = loyaltyProgramId;
            return this;
        }

        public Builder points(int points) {
            this.points = points;
            return this;
        }

        public LoyaltyEventExpirePoints build() {
            return new LoyaltyEventExpirePoints(this.loyaltyProgramId, this.points);
        }
    }
}

