/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.LoyaltyProgramAccrualRule;
import com.squareup.square.models.LoyaltyProgramExpirationPolicy;
import com.squareup.square.models.LoyaltyProgramRewardTier;
import com.squareup.square.models.LoyaltyProgramTerminology;
import java.util.List;
import java.util.Objects;

public class LoyaltyProgram {
    private final String id;
    private final String status;
    private final List<LoyaltyProgramRewardTier> rewardTiers;
    private final LoyaltyProgramExpirationPolicy expirationPolicy;
    private final LoyaltyProgramTerminology terminology;
    private final List<String> locationIds;
    private final String createdAt;
    private final String updatedAt;
    private final List<LoyaltyProgramAccrualRule> accrualRules;

    @JsonCreator
    public LoyaltyProgram(@JsonProperty(value="id") String id, @JsonProperty(value="status") String status, @JsonProperty(value="reward_tiers") List<LoyaltyProgramRewardTier> rewardTiers, @JsonProperty(value="terminology") LoyaltyProgramTerminology terminology, @JsonProperty(value="location_ids") List<String> locationIds, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="updated_at") String updatedAt, @JsonProperty(value="accrual_rules") List<LoyaltyProgramAccrualRule> accrualRules, @JsonProperty(value="expiration_policy") LoyaltyProgramExpirationPolicy expirationPolicy) {
        this.id = id;
        this.status = status;
        this.rewardTiers = rewardTiers;
        this.expirationPolicy = expirationPolicy;
        this.terminology = terminology;
        this.locationIds = locationIds;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.accrualRules = accrualRules;
    }

    @JsonGetter(value="id")
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="status")
    public String getStatus() {
        return this.status;
    }

    @JsonGetter(value="reward_tiers")
    public List<LoyaltyProgramRewardTier> getRewardTiers() {
        return this.rewardTiers;
    }

    @JsonGetter(value="expiration_policy")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public LoyaltyProgramExpirationPolicy getExpirationPolicy() {
        return this.expirationPolicy;
    }

    @JsonGetter(value="terminology")
    public LoyaltyProgramTerminology getTerminology() {
        return this.terminology;
    }

    @JsonGetter(value="location_ids")
    public List<String> getLocationIds() {
        return this.locationIds;
    }

    @JsonGetter(value="created_at")
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonGetter(value="accrual_rules")
    public List<LoyaltyProgramAccrualRule> getAccrualRules() {
        return this.accrualRules;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.status, this.rewardTiers, this.expirationPolicy, this.terminology, this.locationIds, this.createdAt, this.updatedAt, this.accrualRules);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LoyaltyProgram)) {
            return false;
        }
        LoyaltyProgram other = (LoyaltyProgram)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.status, other.status) && Objects.equals(this.rewardTiers, other.rewardTiers) && Objects.equals(this.expirationPolicy, other.expirationPolicy) && Objects.equals(this.terminology, other.terminology) && Objects.equals(this.locationIds, other.locationIds) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt) && Objects.equals(this.accrualRules, other.accrualRules);
    }

    public String toString() {
        return "LoyaltyProgram [id=" + this.id + ", status=" + this.status + ", rewardTiers=" + this.rewardTiers + ", terminology=" + this.terminology + ", locationIds=" + this.locationIds + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", accrualRules=" + this.accrualRules + ", expirationPolicy=" + this.expirationPolicy + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.id, this.status, this.rewardTiers, this.terminology, this.locationIds, this.createdAt, this.updatedAt, this.accrualRules).expirationPolicy(this.getExpirationPolicy());
        return builder;
    }

    public static class Builder {
        private String id;
        private String status;
        private List<LoyaltyProgramRewardTier> rewardTiers;
        private LoyaltyProgramTerminology terminology;
        private List<String> locationIds;
        private String createdAt;
        private String updatedAt;
        private List<LoyaltyProgramAccrualRule> accrualRules;
        private LoyaltyProgramExpirationPolicy expirationPolicy;

        public Builder(String id, String status, List<LoyaltyProgramRewardTier> rewardTiers, LoyaltyProgramTerminology terminology, List<String> locationIds, String createdAt, String updatedAt, List<LoyaltyProgramAccrualRule> accrualRules) {
            this.id = id;
            this.status = status;
            this.rewardTiers = rewardTiers;
            this.terminology = terminology;
            this.locationIds = locationIds;
            this.createdAt = createdAt;
            this.updatedAt = updatedAt;
            this.accrualRules = accrualRules;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder rewardTiers(List<LoyaltyProgramRewardTier> rewardTiers) {
            this.rewardTiers = rewardTiers;
            return this;
        }

        public Builder terminology(LoyaltyProgramTerminology terminology) {
            this.terminology = terminology;
            return this;
        }

        public Builder locationIds(List<String> locationIds) {
            this.locationIds = locationIds;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder accrualRules(List<LoyaltyProgramAccrualRule> accrualRules) {
            this.accrualRules = accrualRules;
            return this;
        }

        public Builder expirationPolicy(LoyaltyProgramExpirationPolicy expirationPolicy) {
            this.expirationPolicy = expirationPolicy;
            return this;
        }

        public LoyaltyProgram build() {
            return new LoyaltyProgram(this.id, this.status, this.rewardTiers, this.terminology, this.locationIds, this.createdAt, this.updatedAt, this.accrualRules, this.expirationPolicy);
        }
    }
}

