/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.LoyaltyProgramAccrualRuleCategoryData;
import com.squareup.square.models.LoyaltyProgramAccrualRuleItemVariationData;
import com.squareup.square.models.LoyaltyProgramAccrualRuleSpendData;
import com.squareup.square.models.LoyaltyProgramAccrualRuleVisitData;
import java.util.Objects;

public class LoyaltyProgramAccrualRule {
    private final String accrualType;
    private final Integer points;
    private final LoyaltyProgramAccrualRuleVisitData visitData;
    private final LoyaltyProgramAccrualRuleSpendData spendData;
    private final LoyaltyProgramAccrualRuleItemVariationData itemVariationData;
    private final LoyaltyProgramAccrualRuleCategoryData categoryData;

    @JsonCreator
    public LoyaltyProgramAccrualRule(@JsonProperty(value="accrual_type") String accrualType, @JsonProperty(value="points") Integer points, @JsonProperty(value="visit_data") LoyaltyProgramAccrualRuleVisitData visitData, @JsonProperty(value="spend_data") LoyaltyProgramAccrualRuleSpendData spendData, @JsonProperty(value="item_variation_data") LoyaltyProgramAccrualRuleItemVariationData itemVariationData, @JsonProperty(value="category_data") LoyaltyProgramAccrualRuleCategoryData categoryData) {
        this.accrualType = accrualType;
        this.points = points;
        this.visitData = visitData;
        this.spendData = spendData;
        this.itemVariationData = itemVariationData;
        this.categoryData = categoryData;
    }

    @JsonGetter(value="accrual_type")
    public String getAccrualType() {
        return this.accrualType;
    }

    @JsonGetter(value="points")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getPoints() {
        return this.points;
    }

    @JsonGetter(value="visit_data")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public LoyaltyProgramAccrualRuleVisitData getVisitData() {
        return this.visitData;
    }

    @JsonGetter(value="spend_data")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public LoyaltyProgramAccrualRuleSpendData getSpendData() {
        return this.spendData;
    }

    @JsonGetter(value="item_variation_data")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public LoyaltyProgramAccrualRuleItemVariationData getItemVariationData() {
        return this.itemVariationData;
    }

    @JsonGetter(value="category_data")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public LoyaltyProgramAccrualRuleCategoryData getCategoryData() {
        return this.categoryData;
    }

    public int hashCode() {
        return Objects.hash(this.accrualType, this.points, this.visitData, this.spendData, this.itemVariationData, this.categoryData);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LoyaltyProgramAccrualRule)) {
            return false;
        }
        LoyaltyProgramAccrualRule other = (LoyaltyProgramAccrualRule)obj;
        return Objects.equals(this.accrualType, other.accrualType) && Objects.equals(this.points, other.points) && Objects.equals(this.visitData, other.visitData) && Objects.equals(this.spendData, other.spendData) && Objects.equals(this.itemVariationData, other.itemVariationData) && Objects.equals(this.categoryData, other.categoryData);
    }

    public String toString() {
        return "LoyaltyProgramAccrualRule [accrualType=" + this.accrualType + ", points=" + this.points + ", visitData=" + this.visitData + ", spendData=" + this.spendData + ", itemVariationData=" + this.itemVariationData + ", categoryData=" + this.categoryData + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.accrualType).points(this.getPoints()).visitData(this.getVisitData()).spendData(this.getSpendData()).itemVariationData(this.getItemVariationData()).categoryData(this.getCategoryData());
        return builder;
    }

    public static class Builder {
        private String accrualType;
        private Integer points;
        private LoyaltyProgramAccrualRuleVisitData visitData;
        private LoyaltyProgramAccrualRuleSpendData spendData;
        private LoyaltyProgramAccrualRuleItemVariationData itemVariationData;
        private LoyaltyProgramAccrualRuleCategoryData categoryData;

        public Builder(String accrualType) {
            this.accrualType = accrualType;
        }

        public Builder accrualType(String accrualType) {
            this.accrualType = accrualType;
            return this;
        }

        public Builder points(Integer points) {
            this.points = points;
            return this;
        }

        public Builder visitData(LoyaltyProgramAccrualRuleVisitData visitData) {
            this.visitData = visitData;
            return this;
        }

        public Builder spendData(LoyaltyProgramAccrualRuleSpendData spendData) {
            this.spendData = spendData;
            return this;
        }

        public Builder itemVariationData(LoyaltyProgramAccrualRuleItemVariationData itemVariationData) {
            this.itemVariationData = itemVariationData;
            return this;
        }

        public Builder categoryData(LoyaltyProgramAccrualRuleCategoryData categoryData) {
            this.categoryData = categoryData;
            return this;
        }

        public LoyaltyProgramAccrualRule build() {
            return new LoyaltyProgramAccrualRule(this.accrualType, this.points, this.visitData, this.spendData, this.itemVariationData, this.categoryData);
        }
    }
}

