/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import java.util.List;
import java.util.Objects;

public class LoyaltyProgramRewardDefinition {
    private final String scope;
    private final String discountType;
    private final String percentageDiscount;
    private final List<String> catalogObjectIds;
    private final Money fixedDiscountMoney;
    private final Money maxDiscountMoney;

    @JsonCreator
    public LoyaltyProgramRewardDefinition(@JsonProperty(value="scope") String scope, @JsonProperty(value="discount_type") String discountType, @JsonProperty(value="percentage_discount") String percentageDiscount, @JsonProperty(value="catalog_object_ids") List<String> catalogObjectIds, @JsonProperty(value="fixed_discount_money") Money fixedDiscountMoney, @JsonProperty(value="max_discount_money") Money maxDiscountMoney) {
        this.scope = scope;
        this.discountType = discountType;
        this.percentageDiscount = percentageDiscount;
        this.catalogObjectIds = catalogObjectIds;
        this.fixedDiscountMoney = fixedDiscountMoney;
        this.maxDiscountMoney = maxDiscountMoney;
    }

    @JsonGetter(value="scope")
    public String getScope() {
        return this.scope;
    }

    @JsonGetter(value="discount_type")
    public String getDiscountType() {
        return this.discountType;
    }

    @JsonGetter(value="percentage_discount")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPercentageDiscount() {
        return this.percentageDiscount;
    }

    @JsonGetter(value="catalog_object_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getCatalogObjectIds() {
        return this.catalogObjectIds;
    }

    @JsonGetter(value="fixed_discount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getFixedDiscountMoney() {
        return this.fixedDiscountMoney;
    }

    @JsonGetter(value="max_discount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getMaxDiscountMoney() {
        return this.maxDiscountMoney;
    }

    public int hashCode() {
        return Objects.hash(this.scope, this.discountType, this.percentageDiscount, this.catalogObjectIds, this.fixedDiscountMoney, this.maxDiscountMoney);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LoyaltyProgramRewardDefinition)) {
            return false;
        }
        LoyaltyProgramRewardDefinition other = (LoyaltyProgramRewardDefinition)obj;
        return Objects.equals(this.scope, other.scope) && Objects.equals(this.discountType, other.discountType) && Objects.equals(this.percentageDiscount, other.percentageDiscount) && Objects.equals(this.catalogObjectIds, other.catalogObjectIds) && Objects.equals(this.fixedDiscountMoney, other.fixedDiscountMoney) && Objects.equals(this.maxDiscountMoney, other.maxDiscountMoney);
    }

    public String toString() {
        return "LoyaltyProgramRewardDefinition [scope=" + this.scope + ", discountType=" + this.discountType + ", percentageDiscount=" + this.percentageDiscount + ", catalogObjectIds=" + this.catalogObjectIds + ", fixedDiscountMoney=" + this.fixedDiscountMoney + ", maxDiscountMoney=" + this.maxDiscountMoney + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.scope, this.discountType).percentageDiscount(this.getPercentageDiscount()).catalogObjectIds(this.getCatalogObjectIds()).fixedDiscountMoney(this.getFixedDiscountMoney()).maxDiscountMoney(this.getMaxDiscountMoney());
        return builder;
    }

    public static class Builder {
        private String scope;
        private String discountType;
        private String percentageDiscount;
        private List<String> catalogObjectIds;
        private Money fixedDiscountMoney;
        private Money maxDiscountMoney;

        public Builder(String scope, String discountType) {
            this.scope = scope;
            this.discountType = discountType;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public Builder discountType(String discountType) {
            this.discountType = discountType;
            return this;
        }

        public Builder percentageDiscount(String percentageDiscount) {
            this.percentageDiscount = percentageDiscount;
            return this;
        }

        public Builder catalogObjectIds(List<String> catalogObjectIds) {
            this.catalogObjectIds = catalogObjectIds;
            return this;
        }

        public Builder fixedDiscountMoney(Money fixedDiscountMoney) {
            this.fixedDiscountMoney = fixedDiscountMoney;
            return this;
        }

        public Builder maxDiscountMoney(Money maxDiscountMoney) {
            this.maxDiscountMoney = maxDiscountMoney;
            return this;
        }

        public LoyaltyProgramRewardDefinition build() {
            return new LoyaltyProgramRewardDefinition(this.scope, this.discountType, this.percentageDiscount, this.catalogObjectIds, this.fixedDiscountMoney, this.maxDiscountMoney);
        }
    }
}

