/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.CatalogObjectReference;
import com.squareup.square.models.LoyaltyProgramRewardDefinition;
import java.util.Objects;

public class LoyaltyProgramRewardTier {
    private final String id;
    private final int points;
    private final String name;
    private final LoyaltyProgramRewardDefinition definition;
    private final String createdAt;
    private final CatalogObjectReference pricingRuleReference;

    @JsonCreator
    public LoyaltyProgramRewardTier(@JsonProperty(value="id") String id, @JsonProperty(value="points") int points, @JsonProperty(value="name") String name, @JsonProperty(value="definition") LoyaltyProgramRewardDefinition definition, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="pricing_rule_reference") CatalogObjectReference pricingRuleReference) {
        this.id = id;
        this.points = points;
        this.name = name;
        this.definition = definition;
        this.createdAt = createdAt;
        this.pricingRuleReference = pricingRuleReference;
    }

    @JsonGetter(value="id")
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="points")
    public int getPoints() {
        return this.points;
    }

    @JsonGetter(value="name")
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="definition")
    public LoyaltyProgramRewardDefinition getDefinition() {
        return this.definition;
    }

    @JsonGetter(value="created_at")
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="pricing_rule_reference")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CatalogObjectReference getPricingRuleReference() {
        return this.pricingRuleReference;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.points, this.name, this.definition, this.createdAt, this.pricingRuleReference);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LoyaltyProgramRewardTier)) {
            return false;
        }
        LoyaltyProgramRewardTier other = (LoyaltyProgramRewardTier)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.points, other.points) && Objects.equals(this.name, other.name) && Objects.equals(this.definition, other.definition) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.pricingRuleReference, other.pricingRuleReference);
    }

    public String toString() {
        return "LoyaltyProgramRewardTier [id=" + this.id + ", points=" + this.points + ", name=" + this.name + ", definition=" + this.definition + ", createdAt=" + this.createdAt + ", pricingRuleReference=" + this.pricingRuleReference + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.id, this.points, this.name, this.definition, this.createdAt).pricingRuleReference(this.getPricingRuleReference());
        return builder;
    }

    public static class Builder {
        private String id;
        private int points;
        private String name;
        private LoyaltyProgramRewardDefinition definition;
        private String createdAt;
        private CatalogObjectReference pricingRuleReference;

        public Builder(String id, int points, String name, LoyaltyProgramRewardDefinition definition, String createdAt) {
            this.id = id;
            this.points = points;
            this.name = name;
            this.definition = definition;
            this.createdAt = createdAt;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder points(int points) {
            this.points = points;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder definition(LoyaltyProgramRewardDefinition definition) {
            this.definition = definition;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder pricingRuleReference(CatalogObjectReference pricingRuleReference) {
            this.pricingRuleReference = pricingRuleReference;
            return this;
        }

        public LoyaltyProgramRewardTier build() {
            return new LoyaltyProgramRewardTier(this.id, this.points, this.name, this.definition, this.createdAt, this.pricingRuleReference);
        }
    }
}

