/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class Merchant {
    private final String id;
    private final String businessName;
    private final String country;
    private final String languageCode;
    private final String currency;
    private final String status;
    private final String mainLocationId;
    private final String createdAt;

    @JsonCreator
    public Merchant(@JsonProperty(value="country") String country, @JsonProperty(value="id") String id, @JsonProperty(value="business_name") String businessName, @JsonProperty(value="language_code") String languageCode, @JsonProperty(value="currency") String currency, @JsonProperty(value="status") String status, @JsonProperty(value="main_location_id") String mainLocationId, @JsonProperty(value="created_at") String createdAt) {
        this.id = id;
        this.businessName = businessName;
        this.country = country;
        this.languageCode = languageCode;
        this.currency = currency;
        this.status = status;
        this.mainLocationId = mainLocationId;
        this.createdAt = createdAt;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="business_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getBusinessName() {
        return this.businessName;
    }

    @JsonGetter(value="country")
    public String getCountry() {
        return this.country;
    }

    @JsonGetter(value="language_code")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLanguageCode() {
        return this.languageCode;
    }

    @JsonGetter(value="currency")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCurrency() {
        return this.currency;
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatus() {
        return this.status;
    }

    @JsonGetter(value="main_location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getMainLocationId() {
        return this.mainLocationId;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.businessName, this.country, this.languageCode, this.currency, this.status, this.mainLocationId, this.createdAt);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Merchant)) {
            return false;
        }
        Merchant other = (Merchant)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.businessName, other.businessName) && Objects.equals(this.country, other.country) && Objects.equals(this.languageCode, other.languageCode) && Objects.equals(this.currency, other.currency) && Objects.equals(this.status, other.status) && Objects.equals(this.mainLocationId, other.mainLocationId) && Objects.equals(this.createdAt, other.createdAt);
    }

    public String toString() {
        return "Merchant [country=" + this.country + ", id=" + this.id + ", businessName=" + this.businessName + ", languageCode=" + this.languageCode + ", currency=" + this.currency + ", status=" + this.status + ", mainLocationId=" + this.mainLocationId + ", createdAt=" + this.createdAt + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.country).id(this.getId()).businessName(this.getBusinessName()).languageCode(this.getLanguageCode()).currency(this.getCurrency()).status(this.getStatus()).mainLocationId(this.getMainLocationId()).createdAt(this.getCreatedAt());
        return builder;
    }

    public static class Builder {
        private String country;
        private String id;
        private String businessName;
        private String languageCode;
        private String currency;
        private String status;
        private String mainLocationId;
        private String createdAt;

        public Builder(String country) {
            this.country = country;
        }

        public Builder country(String country) {
            this.country = country;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder businessName(String businessName) {
            this.businessName = businessName;
            return this;
        }

        public Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder mainLocationId(String mainLocationId) {
            this.mainLocationId = mainLocationId;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Merchant build() {
            return new Merchant(this.country, this.id, this.businessName, this.languageCode, this.currency, this.status, this.mainLocationId, this.createdAt);
        }
    }
}

