/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class Money {
    private final Long amount;
    private final String currency;

    @JsonCreator
    public Money(@JsonProperty(value="amount") Long amount, @JsonProperty(value="currency") String currency) {
        this.amount = amount;
        this.currency = currency;
    }

    @JsonGetter(value="amount")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long getAmount() {
        return this.amount;
    }

    @JsonGetter(value="currency")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCurrency() {
        return this.currency;
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.currency);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Money)) {
            return false;
        }
        Money other = (Money)obj;
        return Objects.equals(this.amount, other.amount) && Objects.equals(this.currency, other.currency);
    }

    public String toString() {
        return "Money [amount=" + this.amount + ", currency=" + this.currency + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().amount(this.getAmount()).currency(this.getCurrency());
        return builder;
    }

    public static class Builder {
        private Long amount;
        private String currency;

        public Builder amount(Long amount) {
            this.amount = amount;
            return this;
        }

        public Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public Money build() {
            return new Money(this.amount, this.currency);
        }
    }
}

