/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public class ObtainTokenRequest {
    private final String clientId;
    private final String clientSecret;
    private final String code;
    private final String redirectUri;
    private final String grantType;
    private final String refreshToken;
    private final String migrationToken;
    private final List<String> scopes;
    private final Boolean shortLived;

    @JsonCreator
    public ObtainTokenRequest(@JsonProperty(value="client_id") String clientId, @JsonProperty(value="client_secret") String clientSecret, @JsonProperty(value="grant_type") String grantType, @JsonProperty(value="code") String code, @JsonProperty(value="redirect_uri") String redirectUri, @JsonProperty(value="refresh_token") String refreshToken, @JsonProperty(value="migration_token") String migrationToken, @JsonProperty(value="scopes") List<String> scopes, @JsonProperty(value="short_lived") Boolean shortLived) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.code = code;
        this.redirectUri = redirectUri;
        this.grantType = grantType;
        this.refreshToken = refreshToken;
        this.migrationToken = migrationToken;
        this.scopes = scopes;
        this.shortLived = shortLived;
    }

    @JsonGetter(value="client_id")
    public String getClientId() {
        return this.clientId;
    }

    @JsonGetter(value="client_secret")
    public String getClientSecret() {
        return this.clientSecret;
    }

    @JsonGetter(value="code")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCode() {
        return this.code;
    }

    @JsonGetter(value="redirect_uri")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getRedirectUri() {
        return this.redirectUri;
    }

    @JsonGetter(value="grant_type")
    public String getGrantType() {
        return this.grantType;
    }

    @JsonGetter(value="refresh_token")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getRefreshToken() {
        return this.refreshToken;
    }

    @JsonGetter(value="migration_token")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getMigrationToken() {
        return this.migrationToken;
    }

    @JsonGetter(value="scopes")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getScopes() {
        return this.scopes;
    }

    @JsonGetter(value="short_lived")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getShortLived() {
        return this.shortLived;
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.clientSecret, this.code, this.redirectUri, this.grantType, this.refreshToken, this.migrationToken, this.scopes, this.shortLived);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ObtainTokenRequest)) {
            return false;
        }
        ObtainTokenRequest other = (ObtainTokenRequest)obj;
        return Objects.equals(this.clientId, other.clientId) && Objects.equals(this.clientSecret, other.clientSecret) && Objects.equals(this.code, other.code) && Objects.equals(this.redirectUri, other.redirectUri) && Objects.equals(this.grantType, other.grantType) && Objects.equals(this.refreshToken, other.refreshToken) && Objects.equals(this.migrationToken, other.migrationToken) && Objects.equals(this.scopes, other.scopes) && Objects.equals(this.shortLived, other.shortLived);
    }

    public String toString() {
        return "ObtainTokenRequest [clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", grantType=" + this.grantType + ", code=" + this.code + ", redirectUri=" + this.redirectUri + ", refreshToken=" + this.refreshToken + ", migrationToken=" + this.migrationToken + ", scopes=" + this.scopes + ", shortLived=" + this.shortLived + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.clientId, this.clientSecret, this.grantType).code(this.getCode()).redirectUri(this.getRedirectUri()).refreshToken(this.getRefreshToken()).migrationToken(this.getMigrationToken()).scopes(this.getScopes()).shortLived(this.getShortLived());
        return builder;
    }

    public static class Builder {
        private String clientId;
        private String clientSecret;
        private String grantType;
        private String code;
        private String redirectUri;
        private String refreshToken;
        private String migrationToken;
        private List<String> scopes;
        private Boolean shortLived;

        public Builder(String clientId, String clientSecret, String grantType) {
            this.clientId = clientId;
            this.clientSecret = clientSecret;
            this.grantType = grantType;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder grantType(String grantType) {
            this.grantType = grantType;
            return this;
        }

        public Builder code(String code) {
            this.code = code;
            return this;
        }

        public Builder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public Builder migrationToken(String migrationToken) {
            this.migrationToken = migrationToken;
            return this;
        }

        public Builder scopes(List<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public Builder shortLived(Boolean shortLived) {
            this.shortLived = shortLived;
            return this;
        }

        public ObtainTokenRequest build() {
            return new ObtainTokenRequest(this.clientId, this.clientSecret, this.grantType, this.code, this.redirectUri, this.refreshToken, this.migrationToken, this.scopes, this.shortLived);
        }
    }
}

