/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class OrderCreated {
    private final String orderId;
    private final Integer version;
    private final String locationId;
    private final String state;
    private final String createdAt;

    @JsonCreator
    public OrderCreated(@JsonProperty(value="order_id") String orderId, @JsonProperty(value="version") Integer version, @JsonProperty(value="location_id") String locationId, @JsonProperty(value="state") String state, @JsonProperty(value="created_at") String createdAt) {
        this.orderId = orderId;
        this.version = version;
        this.locationId = locationId;
        this.state = state;
        this.createdAt = createdAt;
    }

    @JsonGetter(value="order_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getOrderId() {
        return this.orderId;
    }

    @JsonGetter(value="version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getVersion() {
        return this.version;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="state")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getState() {
        return this.state;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    public int hashCode() {
        return Objects.hash(this.orderId, this.version, this.locationId, this.state, this.createdAt);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderCreated)) {
            return false;
        }
        OrderCreated other = (OrderCreated)obj;
        return Objects.equals(this.orderId, other.orderId) && Objects.equals(this.version, other.version) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.state, other.state) && Objects.equals(this.createdAt, other.createdAt);
    }

    public String toString() {
        return "OrderCreated [orderId=" + this.orderId + ", version=" + this.version + ", locationId=" + this.locationId + ", state=" + this.state + ", createdAt=" + this.createdAt + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().orderId(this.getOrderId()).version(this.getVersion()).locationId(this.getLocationId()).state(this.getState()).createdAt(this.getCreatedAt());
        return builder;
    }

    public static class Builder {
        private String orderId;
        private Integer version;
        private String locationId;
        private String state;
        private String createdAt;

        public Builder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public OrderCreated build() {
            return new OrderCreated(this.orderId, this.version, this.locationId, this.state, this.createdAt);
        }
    }
}

