/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class OrderEntry {
    private final String orderId;
    private final Integer version;
    private final String locationId;

    @JsonCreator
    public OrderEntry(@JsonProperty(value="order_id") String orderId, @JsonProperty(value="version") Integer version, @JsonProperty(value="location_id") String locationId) {
        this.orderId = orderId;
        this.version = version;
        this.locationId = locationId;
    }

    @JsonGetter(value="order_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getOrderId() {
        return this.orderId;
    }

    @JsonGetter(value="version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getVersion() {
        return this.version;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLocationId() {
        return this.locationId;
    }

    public int hashCode() {
        return Objects.hash(this.orderId, this.version, this.locationId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderEntry)) {
            return false;
        }
        OrderEntry other = (OrderEntry)obj;
        return Objects.equals(this.orderId, other.orderId) && Objects.equals(this.version, other.version) && Objects.equals(this.locationId, other.locationId);
    }

    public String toString() {
        return "OrderEntry [orderId=" + this.orderId + ", version=" + this.version + ", locationId=" + this.locationId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().orderId(this.getOrderId()).version(this.getVersion()).locationId(this.getLocationId());
        return builder;
    }

    public static class Builder {
        private String orderId;
        private Integer version;
        private String locationId;

        public Builder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public OrderEntry build() {
            return new OrderEntry(this.orderId, this.version, this.locationId);
        }
    }
}

