/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;

public class OrderFulfillmentFulfillmentEntry {
    private final String uid;
    private final String lineItemUid;
    private final String quantity;
    private final Map<String, String> metadata;

    @JsonCreator
    public OrderFulfillmentFulfillmentEntry(@JsonProperty(value="line_item_uid") String lineItemUid, @JsonProperty(value="quantity") String quantity, @JsonProperty(value="uid") String uid, @JsonProperty(value="metadata") Map<String, String> metadata) {
        this.uid = uid;
        this.lineItemUid = lineItemUid;
        this.quantity = quantity;
        this.metadata = metadata;
    }

    @JsonGetter(value="uid")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUid() {
        return this.uid;
    }

    @JsonGetter(value="line_item_uid")
    public String getLineItemUid() {
        return this.lineItemUid;
    }

    @JsonGetter(value="quantity")
    public String getQuantity() {
        return this.quantity;
    }

    @JsonGetter(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.lineItemUid, this.quantity, this.metadata);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderFulfillmentFulfillmentEntry)) {
            return false;
        }
        OrderFulfillmentFulfillmentEntry other = (OrderFulfillmentFulfillmentEntry)obj;
        return Objects.equals(this.uid, other.uid) && Objects.equals(this.lineItemUid, other.lineItemUid) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.metadata, other.metadata);
    }

    public String toString() {
        return "OrderFulfillmentFulfillmentEntry [lineItemUid=" + this.lineItemUid + ", quantity=" + this.quantity + ", uid=" + this.uid + ", metadata=" + this.metadata + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.lineItemUid, this.quantity).uid(this.getUid()).metadata(this.getMetadata());
        return builder;
    }

    public static class Builder {
        private String lineItemUid;
        private String quantity;
        private String uid;
        private Map<String, String> metadata;

        public Builder(String lineItemUid, String quantity) {
            this.lineItemUid = lineItemUid;
            this.quantity = quantity;
        }

        public Builder lineItemUid(String lineItemUid) {
            this.lineItemUid = lineItemUid;
            return this;
        }

        public Builder quantity(String quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public OrderFulfillmentFulfillmentEntry build() {
            return new OrderFulfillmentFulfillmentEntry(this.lineItemUid, this.quantity, this.uid, this.metadata);
        }
    }
}

