/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.OrderFulfillmentPickupDetailsCurbsidePickupDetails;
import com.squareup.square.models.OrderFulfillmentRecipient;
import java.util.Objects;

public class OrderFulfillmentPickupDetails {
    private final OrderFulfillmentRecipient recipient;
    private final String expiresAt;
    private final String autoCompleteDuration;
    private final String scheduleType;
    private final String pickupAt;
    private final String pickupWindowDuration;
    private final String prepTimeDuration;
    private final String note;
    private final String placedAt;
    private final String acceptedAt;
    private final String rejectedAt;
    private final String readyAt;
    private final String expiredAt;
    private final String pickedUpAt;
    private final String canceledAt;
    private final String cancelReason;
    private final Boolean isCurbsidePickup;
    private final OrderFulfillmentPickupDetailsCurbsidePickupDetails curbsidePickupDetails;

    @JsonCreator
    public OrderFulfillmentPickupDetails(@JsonProperty(value="recipient") OrderFulfillmentRecipient recipient, @JsonProperty(value="expires_at") String expiresAt, @JsonProperty(value="auto_complete_duration") String autoCompleteDuration, @JsonProperty(value="schedule_type") String scheduleType, @JsonProperty(value="pickup_at") String pickupAt, @JsonProperty(value="pickup_window_duration") String pickupWindowDuration, @JsonProperty(value="prep_time_duration") String prepTimeDuration, @JsonProperty(value="note") String note, @JsonProperty(value="placed_at") String placedAt, @JsonProperty(value="accepted_at") String acceptedAt, @JsonProperty(value="rejected_at") String rejectedAt, @JsonProperty(value="ready_at") String readyAt, @JsonProperty(value="expired_at") String expiredAt, @JsonProperty(value="picked_up_at") String pickedUpAt, @JsonProperty(value="canceled_at") String canceledAt, @JsonProperty(value="cancel_reason") String cancelReason, @JsonProperty(value="is_curbside_pickup") Boolean isCurbsidePickup, @JsonProperty(value="curbside_pickup_details") OrderFulfillmentPickupDetailsCurbsidePickupDetails curbsidePickupDetails) {
        this.recipient = recipient;
        this.expiresAt = expiresAt;
        this.autoCompleteDuration = autoCompleteDuration;
        this.scheduleType = scheduleType;
        this.pickupAt = pickupAt;
        this.pickupWindowDuration = pickupWindowDuration;
        this.prepTimeDuration = prepTimeDuration;
        this.note = note;
        this.placedAt = placedAt;
        this.acceptedAt = acceptedAt;
        this.rejectedAt = rejectedAt;
        this.readyAt = readyAt;
        this.expiredAt = expiredAt;
        this.pickedUpAt = pickedUpAt;
        this.canceledAt = canceledAt;
        this.cancelReason = cancelReason;
        this.isCurbsidePickup = isCurbsidePickup;
        this.curbsidePickupDetails = curbsidePickupDetails;
    }

    @JsonGetter(value="recipient")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public OrderFulfillmentRecipient getRecipient() {
        return this.recipient;
    }

    @JsonGetter(value="expires_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getExpiresAt() {
        return this.expiresAt;
    }

    @JsonGetter(value="auto_complete_duration")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAutoCompleteDuration() {
        return this.autoCompleteDuration;
    }

    @JsonGetter(value="schedule_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getScheduleType() {
        return this.scheduleType;
    }

    @JsonGetter(value="pickup_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPickupAt() {
        return this.pickupAt;
    }

    @JsonGetter(value="pickup_window_duration")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPickupWindowDuration() {
        return this.pickupWindowDuration;
    }

    @JsonGetter(value="prep_time_duration")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPrepTimeDuration() {
        return this.prepTimeDuration;
    }

    @JsonGetter(value="note")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getNote() {
        return this.note;
    }

    @JsonGetter(value="placed_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPlacedAt() {
        return this.placedAt;
    }

    @JsonGetter(value="accepted_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAcceptedAt() {
        return this.acceptedAt;
    }

    @JsonGetter(value="rejected_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getRejectedAt() {
        return this.rejectedAt;
    }

    @JsonGetter(value="ready_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getReadyAt() {
        return this.readyAt;
    }

    @JsonGetter(value="expired_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getExpiredAt() {
        return this.expiredAt;
    }

    @JsonGetter(value="picked_up_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPickedUpAt() {
        return this.pickedUpAt;
    }

    @JsonGetter(value="canceled_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCanceledAt() {
        return this.canceledAt;
    }

    @JsonGetter(value="cancel_reason")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCancelReason() {
        return this.cancelReason;
    }

    @JsonGetter(value="is_curbside_pickup")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getIsCurbsidePickup() {
        return this.isCurbsidePickup;
    }

    @JsonGetter(value="curbside_pickup_details")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public OrderFulfillmentPickupDetailsCurbsidePickupDetails getCurbsidePickupDetails() {
        return this.curbsidePickupDetails;
    }

    public int hashCode() {
        return Objects.hash(this.recipient, this.expiresAt, this.autoCompleteDuration, this.scheduleType, this.pickupAt, this.pickupWindowDuration, this.prepTimeDuration, this.note, this.placedAt, this.acceptedAt, this.rejectedAt, this.readyAt, this.expiredAt, this.pickedUpAt, this.canceledAt, this.cancelReason, this.isCurbsidePickup, this.curbsidePickupDetails);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderFulfillmentPickupDetails)) {
            return false;
        }
        OrderFulfillmentPickupDetails other = (OrderFulfillmentPickupDetails)obj;
        return Objects.equals(this.recipient, other.recipient) && Objects.equals(this.expiresAt, other.expiresAt) && Objects.equals(this.autoCompleteDuration, other.autoCompleteDuration) && Objects.equals(this.scheduleType, other.scheduleType) && Objects.equals(this.pickupAt, other.pickupAt) && Objects.equals(this.pickupWindowDuration, other.pickupWindowDuration) && Objects.equals(this.prepTimeDuration, other.prepTimeDuration) && Objects.equals(this.note, other.note) && Objects.equals(this.placedAt, other.placedAt) && Objects.equals(this.acceptedAt, other.acceptedAt) && Objects.equals(this.rejectedAt, other.rejectedAt) && Objects.equals(this.readyAt, other.readyAt) && Objects.equals(this.expiredAt, other.expiredAt) && Objects.equals(this.pickedUpAt, other.pickedUpAt) && Objects.equals(this.canceledAt, other.canceledAt) && Objects.equals(this.cancelReason, other.cancelReason) && Objects.equals(this.isCurbsidePickup, other.isCurbsidePickup) && Objects.equals(this.curbsidePickupDetails, other.curbsidePickupDetails);
    }

    public String toString() {
        return "OrderFulfillmentPickupDetails [recipient=" + this.recipient + ", expiresAt=" + this.expiresAt + ", autoCompleteDuration=" + this.autoCompleteDuration + ", scheduleType=" + this.scheduleType + ", pickupAt=" + this.pickupAt + ", pickupWindowDuration=" + this.pickupWindowDuration + ", prepTimeDuration=" + this.prepTimeDuration + ", note=" + this.note + ", placedAt=" + this.placedAt + ", acceptedAt=" + this.acceptedAt + ", rejectedAt=" + this.rejectedAt + ", readyAt=" + this.readyAt + ", expiredAt=" + this.expiredAt + ", pickedUpAt=" + this.pickedUpAt + ", canceledAt=" + this.canceledAt + ", cancelReason=" + this.cancelReason + ", isCurbsidePickup=" + this.isCurbsidePickup + ", curbsidePickupDetails=" + this.curbsidePickupDetails + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().recipient(this.getRecipient()).expiresAt(this.getExpiresAt()).autoCompleteDuration(this.getAutoCompleteDuration()).scheduleType(this.getScheduleType()).pickupAt(this.getPickupAt()).pickupWindowDuration(this.getPickupWindowDuration()).prepTimeDuration(this.getPrepTimeDuration()).note(this.getNote()).placedAt(this.getPlacedAt()).acceptedAt(this.getAcceptedAt()).rejectedAt(this.getRejectedAt()).readyAt(this.getReadyAt()).expiredAt(this.getExpiredAt()).pickedUpAt(this.getPickedUpAt()).canceledAt(this.getCanceledAt()).cancelReason(this.getCancelReason()).isCurbsidePickup(this.getIsCurbsidePickup()).curbsidePickupDetails(this.getCurbsidePickupDetails());
        return builder;
    }

    public static class Builder {
        private OrderFulfillmentRecipient recipient;
        private String expiresAt;
        private String autoCompleteDuration;
        private String scheduleType;
        private String pickupAt;
        private String pickupWindowDuration;
        private String prepTimeDuration;
        private String note;
        private String placedAt;
        private String acceptedAt;
        private String rejectedAt;
        private String readyAt;
        private String expiredAt;
        private String pickedUpAt;
        private String canceledAt;
        private String cancelReason;
        private Boolean isCurbsidePickup;
        private OrderFulfillmentPickupDetailsCurbsidePickupDetails curbsidePickupDetails;

        public Builder recipient(OrderFulfillmentRecipient recipient) {
            this.recipient = recipient;
            return this;
        }

        public Builder expiresAt(String expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public Builder autoCompleteDuration(String autoCompleteDuration) {
            this.autoCompleteDuration = autoCompleteDuration;
            return this;
        }

        public Builder scheduleType(String scheduleType) {
            this.scheduleType = scheduleType;
            return this;
        }

        public Builder pickupAt(String pickupAt) {
            this.pickupAt = pickupAt;
            return this;
        }

        public Builder pickupWindowDuration(String pickupWindowDuration) {
            this.pickupWindowDuration = pickupWindowDuration;
            return this;
        }

        public Builder prepTimeDuration(String prepTimeDuration) {
            this.prepTimeDuration = prepTimeDuration;
            return this;
        }

        public Builder note(String note) {
            this.note = note;
            return this;
        }

        public Builder placedAt(String placedAt) {
            this.placedAt = placedAt;
            return this;
        }

        public Builder acceptedAt(String acceptedAt) {
            this.acceptedAt = acceptedAt;
            return this;
        }

        public Builder rejectedAt(String rejectedAt) {
            this.rejectedAt = rejectedAt;
            return this;
        }

        public Builder readyAt(String readyAt) {
            this.readyAt = readyAt;
            return this;
        }

        public Builder expiredAt(String expiredAt) {
            this.expiredAt = expiredAt;
            return this;
        }

        public Builder pickedUpAt(String pickedUpAt) {
            this.pickedUpAt = pickedUpAt;
            return this;
        }

        public Builder canceledAt(String canceledAt) {
            this.canceledAt = canceledAt;
            return this;
        }

        public Builder cancelReason(String cancelReason) {
            this.cancelReason = cancelReason;
            return this;
        }

        public Builder isCurbsidePickup(Boolean isCurbsidePickup) {
            this.isCurbsidePickup = isCurbsidePickup;
            return this;
        }

        public Builder curbsidePickupDetails(OrderFulfillmentPickupDetailsCurbsidePickupDetails curbsidePickupDetails) {
            this.curbsidePickupDetails = curbsidePickupDetails;
            return this;
        }

        public OrderFulfillmentPickupDetails build() {
            return new OrderFulfillmentPickupDetails(this.recipient, this.expiresAt, this.autoCompleteDuration, this.scheduleType, this.pickupAt, this.pickupWindowDuration, this.prepTimeDuration, this.note, this.placedAt, this.acceptedAt, this.rejectedAt, this.readyAt, this.expiredAt, this.pickedUpAt, this.canceledAt, this.cancelReason, this.isCurbsidePickup, this.curbsidePickupDetails);
        }
    }
}

