/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Address;
import java.util.Objects;

public class OrderFulfillmentRecipient {
    private final String customerId;
    private final String displayName;
    private final String emailAddress;
    private final String phoneNumber;
    private final Address address;

    @JsonCreator
    public OrderFulfillmentRecipient(@JsonProperty(value="customer_id") String customerId, @JsonProperty(value="display_name") String displayName, @JsonProperty(value="email_address") String emailAddress, @JsonProperty(value="phone_number") String phoneNumber, @JsonProperty(value="address") Address address) {
        this.customerId = customerId;
        this.displayName = displayName;
        this.emailAddress = emailAddress;
        this.phoneNumber = phoneNumber;
        this.address = address;
    }

    @JsonGetter(value="customer_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCustomerId() {
        return this.customerId;
    }

    @JsonGetter(value="display_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonGetter(value="email_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @JsonGetter(value="phone_number")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonGetter(value="address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Address getAddress() {
        return this.address;
    }

    public int hashCode() {
        return Objects.hash(this.customerId, this.displayName, this.emailAddress, this.phoneNumber, this.address);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderFulfillmentRecipient)) {
            return false;
        }
        OrderFulfillmentRecipient other = (OrderFulfillmentRecipient)obj;
        return Objects.equals(this.customerId, other.customerId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.emailAddress, other.emailAddress) && Objects.equals(this.phoneNumber, other.phoneNumber) && Objects.equals(this.address, other.address);
    }

    public String toString() {
        return "OrderFulfillmentRecipient [customerId=" + this.customerId + ", displayName=" + this.displayName + ", emailAddress=" + this.emailAddress + ", phoneNumber=" + this.phoneNumber + ", address=" + this.address + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().customerId(this.getCustomerId()).displayName(this.getDisplayName()).emailAddress(this.getEmailAddress()).phoneNumber(this.getPhoneNumber()).address(this.getAddress());
        return builder;
    }

    public static class Builder {
        private String customerId;
        private String displayName;
        private String emailAddress;
        private String phoneNumber;
        private Address address;

        public Builder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public Builder address(Address address) {
            this.address = address;
            return this;
        }

        public OrderFulfillmentRecipient build() {
            return new OrderFulfillmentRecipient(this.customerId, this.displayName, this.emailAddress, this.phoneNumber, this.address);
        }
    }
}

