/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.OrderFulfillmentRecipient;
import java.util.Objects;

public class OrderFulfillmentShipmentDetails {
    private final OrderFulfillmentRecipient recipient;
    private final String carrier;
    private final String shippingNote;
    private final String shippingType;
    private final String trackingNumber;
    private final String trackingUrl;
    private final String placedAt;
    private final String inProgressAt;
    private final String packagedAt;
    private final String expectedShippedAt;
    private final String shippedAt;
    private final String canceledAt;
    private final String cancelReason;
    private final String failedAt;
    private final String failureReason;

    @JsonCreator
    public OrderFulfillmentShipmentDetails(@JsonProperty(value="recipient") OrderFulfillmentRecipient recipient, @JsonProperty(value="carrier") String carrier, @JsonProperty(value="shipping_note") String shippingNote, @JsonProperty(value="shipping_type") String shippingType, @JsonProperty(value="tracking_number") String trackingNumber, @JsonProperty(value="tracking_url") String trackingUrl, @JsonProperty(value="placed_at") String placedAt, @JsonProperty(value="in_progress_at") String inProgressAt, @JsonProperty(value="packaged_at") String packagedAt, @JsonProperty(value="expected_shipped_at") String expectedShippedAt, @JsonProperty(value="shipped_at") String shippedAt, @JsonProperty(value="canceled_at") String canceledAt, @JsonProperty(value="cancel_reason") String cancelReason, @JsonProperty(value="failed_at") String failedAt, @JsonProperty(value="failure_reason") String failureReason) {
        this.recipient = recipient;
        this.carrier = carrier;
        this.shippingNote = shippingNote;
        this.shippingType = shippingType;
        this.trackingNumber = trackingNumber;
        this.trackingUrl = trackingUrl;
        this.placedAt = placedAt;
        this.inProgressAt = inProgressAt;
        this.packagedAt = packagedAt;
        this.expectedShippedAt = expectedShippedAt;
        this.shippedAt = shippedAt;
        this.canceledAt = canceledAt;
        this.cancelReason = cancelReason;
        this.failedAt = failedAt;
        this.failureReason = failureReason;
    }

    @JsonGetter(value="recipient")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public OrderFulfillmentRecipient getRecipient() {
        return this.recipient;
    }

    @JsonGetter(value="carrier")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCarrier() {
        return this.carrier;
    }

    @JsonGetter(value="shipping_note")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getShippingNote() {
        return this.shippingNote;
    }

    @JsonGetter(value="shipping_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getShippingType() {
        return this.shippingType;
    }

    @JsonGetter(value="tracking_number")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTrackingNumber() {
        return this.trackingNumber;
    }

    @JsonGetter(value="tracking_url")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTrackingUrl() {
        return this.trackingUrl;
    }

    @JsonGetter(value="placed_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPlacedAt() {
        return this.placedAt;
    }

    @JsonGetter(value="in_progress_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getInProgressAt() {
        return this.inProgressAt;
    }

    @JsonGetter(value="packaged_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPackagedAt() {
        return this.packagedAt;
    }

    @JsonGetter(value="expected_shipped_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getExpectedShippedAt() {
        return this.expectedShippedAt;
    }

    @JsonGetter(value="shipped_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getShippedAt() {
        return this.shippedAt;
    }

    @JsonGetter(value="canceled_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCanceledAt() {
        return this.canceledAt;
    }

    @JsonGetter(value="cancel_reason")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCancelReason() {
        return this.cancelReason;
    }

    @JsonGetter(value="failed_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getFailedAt() {
        return this.failedAt;
    }

    @JsonGetter(value="failure_reason")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getFailureReason() {
        return this.failureReason;
    }

    public int hashCode() {
        return Objects.hash(this.recipient, this.carrier, this.shippingNote, this.shippingType, this.trackingNumber, this.trackingUrl, this.placedAt, this.inProgressAt, this.packagedAt, this.expectedShippedAt, this.shippedAt, this.canceledAt, this.cancelReason, this.failedAt, this.failureReason);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderFulfillmentShipmentDetails)) {
            return false;
        }
        OrderFulfillmentShipmentDetails other = (OrderFulfillmentShipmentDetails)obj;
        return Objects.equals(this.recipient, other.recipient) && Objects.equals(this.carrier, other.carrier) && Objects.equals(this.shippingNote, other.shippingNote) && Objects.equals(this.shippingType, other.shippingType) && Objects.equals(this.trackingNumber, other.trackingNumber) && Objects.equals(this.trackingUrl, other.trackingUrl) && Objects.equals(this.placedAt, other.placedAt) && Objects.equals(this.inProgressAt, other.inProgressAt) && Objects.equals(this.packagedAt, other.packagedAt) && Objects.equals(this.expectedShippedAt, other.expectedShippedAt) && Objects.equals(this.shippedAt, other.shippedAt) && Objects.equals(this.canceledAt, other.canceledAt) && Objects.equals(this.cancelReason, other.cancelReason) && Objects.equals(this.failedAt, other.failedAt) && Objects.equals(this.failureReason, other.failureReason);
    }

    public String toString() {
        return "OrderFulfillmentShipmentDetails [recipient=" + this.recipient + ", carrier=" + this.carrier + ", shippingNote=" + this.shippingNote + ", shippingType=" + this.shippingType + ", trackingNumber=" + this.trackingNumber + ", trackingUrl=" + this.trackingUrl + ", placedAt=" + this.placedAt + ", inProgressAt=" + this.inProgressAt + ", packagedAt=" + this.packagedAt + ", expectedShippedAt=" + this.expectedShippedAt + ", shippedAt=" + this.shippedAt + ", canceledAt=" + this.canceledAt + ", cancelReason=" + this.cancelReason + ", failedAt=" + this.failedAt + ", failureReason=" + this.failureReason + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().recipient(this.getRecipient()).carrier(this.getCarrier()).shippingNote(this.getShippingNote()).shippingType(this.getShippingType()).trackingNumber(this.getTrackingNumber()).trackingUrl(this.getTrackingUrl()).placedAt(this.getPlacedAt()).inProgressAt(this.getInProgressAt()).packagedAt(this.getPackagedAt()).expectedShippedAt(this.getExpectedShippedAt()).shippedAt(this.getShippedAt()).canceledAt(this.getCanceledAt()).cancelReason(this.getCancelReason()).failedAt(this.getFailedAt()).failureReason(this.getFailureReason());
        return builder;
    }

    public static class Builder {
        private OrderFulfillmentRecipient recipient;
        private String carrier;
        private String shippingNote;
        private String shippingType;
        private String trackingNumber;
        private String trackingUrl;
        private String placedAt;
        private String inProgressAt;
        private String packagedAt;
        private String expectedShippedAt;
        private String shippedAt;
        private String canceledAt;
        private String cancelReason;
        private String failedAt;
        private String failureReason;

        public Builder recipient(OrderFulfillmentRecipient recipient) {
            this.recipient = recipient;
            return this;
        }

        public Builder carrier(String carrier) {
            this.carrier = carrier;
            return this;
        }

        public Builder shippingNote(String shippingNote) {
            this.shippingNote = shippingNote;
            return this;
        }

        public Builder shippingType(String shippingType) {
            this.shippingType = shippingType;
            return this;
        }

        public Builder trackingNumber(String trackingNumber) {
            this.trackingNumber = trackingNumber;
            return this;
        }

        public Builder trackingUrl(String trackingUrl) {
            this.trackingUrl = trackingUrl;
            return this;
        }

        public Builder placedAt(String placedAt) {
            this.placedAt = placedAt;
            return this;
        }

        public Builder inProgressAt(String inProgressAt) {
            this.inProgressAt = inProgressAt;
            return this;
        }

        public Builder packagedAt(String packagedAt) {
            this.packagedAt = packagedAt;
            return this;
        }

        public Builder expectedShippedAt(String expectedShippedAt) {
            this.expectedShippedAt = expectedShippedAt;
            return this;
        }

        public Builder shippedAt(String shippedAt) {
            this.shippedAt = shippedAt;
            return this;
        }

        public Builder canceledAt(String canceledAt) {
            this.canceledAt = canceledAt;
            return this;
        }

        public Builder cancelReason(String cancelReason) {
            this.cancelReason = cancelReason;
            return this;
        }

        public Builder failedAt(String failedAt) {
            this.failedAt = failedAt;
            return this;
        }

        public Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public OrderFulfillmentShipmentDetails build() {
            return new OrderFulfillmentShipmentDetails(this.recipient, this.carrier, this.shippingNote, this.shippingType, this.trackingNumber, this.trackingUrl, this.placedAt, this.inProgressAt, this.packagedAt, this.expectedShippedAt, this.shippedAt, this.canceledAt, this.cancelReason, this.failedAt, this.failureReason);
        }
    }
}

