/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import com.squareup.square.models.OrderLineItemAppliedDiscount;
import com.squareup.square.models.OrderLineItemAppliedTax;
import com.squareup.square.models.OrderLineItemModifier;
import com.squareup.square.models.OrderLineItemPricingBlocklists;
import com.squareup.square.models.OrderQuantityUnit;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class OrderLineItem {
    private final String uid;
    private final String name;
    private final String quantity;
    private final OrderQuantityUnit quantityUnit;
    private final String note;
    private final String catalogObjectId;
    private final Long catalogVersion;
    private final String variationName;
    private final String itemType;
    private final Map<String, String> metadata;
    private final List<OrderLineItemModifier> modifiers;
    private final List<OrderLineItemAppliedTax> appliedTaxes;
    private final List<OrderLineItemAppliedDiscount> appliedDiscounts;
    private final Money basePriceMoney;
    private final Money variationTotalPriceMoney;
    private final Money grossSalesMoney;
    private final Money totalTaxMoney;
    private final Money totalDiscountMoney;
    private final Money totalMoney;
    private final OrderLineItemPricingBlocklists pricingBlocklists;

    @JsonCreator
    public OrderLineItem(@JsonProperty(value="quantity") String quantity, @JsonProperty(value="uid") String uid, @JsonProperty(value="name") String name, @JsonProperty(value="quantity_unit") OrderQuantityUnit quantityUnit, @JsonProperty(value="note") String note, @JsonProperty(value="catalog_object_id") String catalogObjectId, @JsonProperty(value="catalog_version") Long catalogVersion, @JsonProperty(value="variation_name") String variationName, @JsonProperty(value="item_type") String itemType, @JsonProperty(value="metadata") Map<String, String> metadata, @JsonProperty(value="modifiers") List<OrderLineItemModifier> modifiers, @JsonProperty(value="applied_taxes") List<OrderLineItemAppliedTax> appliedTaxes, @JsonProperty(value="applied_discounts") List<OrderLineItemAppliedDiscount> appliedDiscounts, @JsonProperty(value="base_price_money") Money basePriceMoney, @JsonProperty(value="variation_total_price_money") Money variationTotalPriceMoney, @JsonProperty(value="gross_sales_money") Money grossSalesMoney, @JsonProperty(value="total_tax_money") Money totalTaxMoney, @JsonProperty(value="total_discount_money") Money totalDiscountMoney, @JsonProperty(value="total_money") Money totalMoney, @JsonProperty(value="pricing_blocklists") OrderLineItemPricingBlocklists pricingBlocklists) {
        this.uid = uid;
        this.name = name;
        this.quantity = quantity;
        this.quantityUnit = quantityUnit;
        this.note = note;
        this.catalogObjectId = catalogObjectId;
        this.catalogVersion = catalogVersion;
        this.variationName = variationName;
        this.itemType = itemType;
        this.metadata = metadata;
        this.modifiers = modifiers;
        this.appliedTaxes = appliedTaxes;
        this.appliedDiscounts = appliedDiscounts;
        this.basePriceMoney = basePriceMoney;
        this.variationTotalPriceMoney = variationTotalPriceMoney;
        this.grossSalesMoney = grossSalesMoney;
        this.totalTaxMoney = totalTaxMoney;
        this.totalDiscountMoney = totalDiscountMoney;
        this.totalMoney = totalMoney;
        this.pricingBlocklists = pricingBlocklists;
    }

    @JsonGetter(value="uid")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUid() {
        return this.uid;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="quantity")
    public String getQuantity() {
        return this.quantity;
    }

    @JsonGetter(value="quantity_unit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public OrderQuantityUnit getQuantityUnit() {
        return this.quantityUnit;
    }

    @JsonGetter(value="note")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getNote() {
        return this.note;
    }

    @JsonGetter(value="catalog_object_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCatalogObjectId() {
        return this.catalogObjectId;
    }

    @JsonGetter(value="catalog_version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long getCatalogVersion() {
        return this.catalogVersion;
    }

    @JsonGetter(value="variation_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getVariationName() {
        return this.variationName;
    }

    @JsonGetter(value="item_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getItemType() {
        return this.itemType;
    }

    @JsonGetter(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonGetter(value="modifiers")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<OrderLineItemModifier> getModifiers() {
        return this.modifiers;
    }

    @JsonGetter(value="applied_taxes")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<OrderLineItemAppliedTax> getAppliedTaxes() {
        return this.appliedTaxes;
    }

    @JsonGetter(value="applied_discounts")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<OrderLineItemAppliedDiscount> getAppliedDiscounts() {
        return this.appliedDiscounts;
    }

    @JsonGetter(value="base_price_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getBasePriceMoney() {
        return this.basePriceMoney;
    }

    @JsonGetter(value="variation_total_price_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getVariationTotalPriceMoney() {
        return this.variationTotalPriceMoney;
    }

    @JsonGetter(value="gross_sales_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getGrossSalesMoney() {
        return this.grossSalesMoney;
    }

    @JsonGetter(value="total_tax_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTotalTaxMoney() {
        return this.totalTaxMoney;
    }

    @JsonGetter(value="total_discount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTotalDiscountMoney() {
        return this.totalDiscountMoney;
    }

    @JsonGetter(value="total_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTotalMoney() {
        return this.totalMoney;
    }

    @JsonGetter(value="pricing_blocklists")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public OrderLineItemPricingBlocklists getPricingBlocklists() {
        return this.pricingBlocklists;
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.name, this.quantity, this.quantityUnit, this.note, this.catalogObjectId, this.catalogVersion, this.variationName, this.itemType, this.metadata, this.modifiers, this.appliedTaxes, this.appliedDiscounts, this.basePriceMoney, this.variationTotalPriceMoney, this.grossSalesMoney, this.totalTaxMoney, this.totalDiscountMoney, this.totalMoney, this.pricingBlocklists);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderLineItem)) {
            return false;
        }
        OrderLineItem other = (OrderLineItem)obj;
        return Objects.equals(this.uid, other.uid) && Objects.equals(this.name, other.name) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.quantityUnit, other.quantityUnit) && Objects.equals(this.note, other.note) && Objects.equals(this.catalogObjectId, other.catalogObjectId) && Objects.equals(this.catalogVersion, other.catalogVersion) && Objects.equals(this.variationName, other.variationName) && Objects.equals(this.itemType, other.itemType) && Objects.equals(this.metadata, other.metadata) && Objects.equals(this.modifiers, other.modifiers) && Objects.equals(this.appliedTaxes, other.appliedTaxes) && Objects.equals(this.appliedDiscounts, other.appliedDiscounts) && Objects.equals(this.basePriceMoney, other.basePriceMoney) && Objects.equals(this.variationTotalPriceMoney, other.variationTotalPriceMoney) && Objects.equals(this.grossSalesMoney, other.grossSalesMoney) && Objects.equals(this.totalTaxMoney, other.totalTaxMoney) && Objects.equals(this.totalDiscountMoney, other.totalDiscountMoney) && Objects.equals(this.totalMoney, other.totalMoney) && Objects.equals(this.pricingBlocklists, other.pricingBlocklists);
    }

    public String toString() {
        return "OrderLineItem [quantity=" + this.quantity + ", uid=" + this.uid + ", name=" + this.name + ", quantityUnit=" + this.quantityUnit + ", note=" + this.note + ", catalogObjectId=" + this.catalogObjectId + ", catalogVersion=" + this.catalogVersion + ", variationName=" + this.variationName + ", itemType=" + this.itemType + ", metadata=" + this.metadata + ", modifiers=" + this.modifiers + ", appliedTaxes=" + this.appliedTaxes + ", appliedDiscounts=" + this.appliedDiscounts + ", basePriceMoney=" + this.basePriceMoney + ", variationTotalPriceMoney=" + this.variationTotalPriceMoney + ", grossSalesMoney=" + this.grossSalesMoney + ", totalTaxMoney=" + this.totalTaxMoney + ", totalDiscountMoney=" + this.totalDiscountMoney + ", totalMoney=" + this.totalMoney + ", pricingBlocklists=" + this.pricingBlocklists + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.quantity).uid(this.getUid()).name(this.getName()).quantityUnit(this.getQuantityUnit()).note(this.getNote()).catalogObjectId(this.getCatalogObjectId()).catalogVersion(this.getCatalogVersion()).variationName(this.getVariationName()).itemType(this.getItemType()).metadata(this.getMetadata()).modifiers(this.getModifiers()).appliedTaxes(this.getAppliedTaxes()).appliedDiscounts(this.getAppliedDiscounts()).basePriceMoney(this.getBasePriceMoney()).variationTotalPriceMoney(this.getVariationTotalPriceMoney()).grossSalesMoney(this.getGrossSalesMoney()).totalTaxMoney(this.getTotalTaxMoney()).totalDiscountMoney(this.getTotalDiscountMoney()).totalMoney(this.getTotalMoney()).pricingBlocklists(this.getPricingBlocklists());
        return builder;
    }

    public static class Builder {
        private String quantity;
        private String uid;
        private String name;
        private OrderQuantityUnit quantityUnit;
        private String note;
        private String catalogObjectId;
        private Long catalogVersion;
        private String variationName;
        private String itemType;
        private Map<String, String> metadata;
        private List<OrderLineItemModifier> modifiers;
        private List<OrderLineItemAppliedTax> appliedTaxes;
        private List<OrderLineItemAppliedDiscount> appliedDiscounts;
        private Money basePriceMoney;
        private Money variationTotalPriceMoney;
        private Money grossSalesMoney;
        private Money totalTaxMoney;
        private Money totalDiscountMoney;
        private Money totalMoney;
        private OrderLineItemPricingBlocklists pricingBlocklists;

        public Builder(String quantity) {
            this.quantity = quantity;
        }

        public Builder quantity(String quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder quantityUnit(OrderQuantityUnit quantityUnit) {
            this.quantityUnit = quantityUnit;
            return this;
        }

        public Builder note(String note) {
            this.note = note;
            return this;
        }

        public Builder catalogObjectId(String catalogObjectId) {
            this.catalogObjectId = catalogObjectId;
            return this;
        }

        public Builder catalogVersion(Long catalogVersion) {
            this.catalogVersion = catalogVersion;
            return this;
        }

        public Builder variationName(String variationName) {
            this.variationName = variationName;
            return this;
        }

        public Builder itemType(String itemType) {
            this.itemType = itemType;
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder modifiers(List<OrderLineItemModifier> modifiers) {
            this.modifiers = modifiers;
            return this;
        }

        public Builder appliedTaxes(List<OrderLineItemAppliedTax> appliedTaxes) {
            this.appliedTaxes = appliedTaxes;
            return this;
        }

        public Builder appliedDiscounts(List<OrderLineItemAppliedDiscount> appliedDiscounts) {
            this.appliedDiscounts = appliedDiscounts;
            return this;
        }

        public Builder basePriceMoney(Money basePriceMoney) {
            this.basePriceMoney = basePriceMoney;
            return this;
        }

        public Builder variationTotalPriceMoney(Money variationTotalPriceMoney) {
            this.variationTotalPriceMoney = variationTotalPriceMoney;
            return this;
        }

        public Builder grossSalesMoney(Money grossSalesMoney) {
            this.grossSalesMoney = grossSalesMoney;
            return this;
        }

        public Builder totalTaxMoney(Money totalTaxMoney) {
            this.totalTaxMoney = totalTaxMoney;
            return this;
        }

        public Builder totalDiscountMoney(Money totalDiscountMoney) {
            this.totalDiscountMoney = totalDiscountMoney;
            return this;
        }

        public Builder totalMoney(Money totalMoney) {
            this.totalMoney = totalMoney;
            return this;
        }

        public Builder pricingBlocklists(OrderLineItemPricingBlocklists pricingBlocklists) {
            this.pricingBlocklists = pricingBlocklists;
            return this;
        }

        public OrderLineItem build() {
            return new OrderLineItem(this.quantity, this.uid, this.name, this.quantityUnit, this.note, this.catalogObjectId, this.catalogVersion, this.variationName, this.itemType, this.metadata, this.modifiers, this.appliedTaxes, this.appliedDiscounts, this.basePriceMoney, this.variationTotalPriceMoney, this.grossSalesMoney, this.totalTaxMoney, this.totalDiscountMoney, this.totalMoney, this.pricingBlocklists);
        }
    }
}

