/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import java.util.Objects;

public class OrderLineItemAppliedDiscount {
    private final String uid;
    private final String discountUid;
    private final Money appliedMoney;

    @JsonCreator
    public OrderLineItemAppliedDiscount(@JsonProperty(value="discount_uid") String discountUid, @JsonProperty(value="uid") String uid, @JsonProperty(value="applied_money") Money appliedMoney) {
        this.uid = uid;
        this.discountUid = discountUid;
        this.appliedMoney = appliedMoney;
    }

    @JsonGetter(value="uid")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUid() {
        return this.uid;
    }

    @JsonGetter(value="discount_uid")
    public String getDiscountUid() {
        return this.discountUid;
    }

    @JsonGetter(value="applied_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAppliedMoney() {
        return this.appliedMoney;
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.discountUid, this.appliedMoney);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderLineItemAppliedDiscount)) {
            return false;
        }
        OrderLineItemAppliedDiscount other = (OrderLineItemAppliedDiscount)obj;
        return Objects.equals(this.uid, other.uid) && Objects.equals(this.discountUid, other.discountUid) && Objects.equals(this.appliedMoney, other.appliedMoney);
    }

    public String toString() {
        return "OrderLineItemAppliedDiscount [discountUid=" + this.discountUid + ", uid=" + this.uid + ", appliedMoney=" + this.appliedMoney + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.discountUid).uid(this.getUid()).appliedMoney(this.getAppliedMoney());
        return builder;
    }

    public static class Builder {
        private String discountUid;
        private String uid;
        private Money appliedMoney;

        public Builder(String discountUid) {
            this.discountUid = discountUid;
        }

        public Builder discountUid(String discountUid) {
            this.discountUid = discountUid;
            return this;
        }

        public Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public Builder appliedMoney(Money appliedMoney) {
            this.appliedMoney = appliedMoney;
            return this;
        }

        public OrderLineItemAppliedDiscount build() {
            return new OrderLineItemAppliedDiscount(this.discountUid, this.uid, this.appliedMoney);
        }
    }
}

