/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import java.util.Objects;

public class OrderLineItemAppliedTax {
    private final String uid;
    private final String taxUid;
    private final Money appliedMoney;

    @JsonCreator
    public OrderLineItemAppliedTax(@JsonProperty(value="tax_uid") String taxUid, @JsonProperty(value="uid") String uid, @JsonProperty(value="applied_money") Money appliedMoney) {
        this.uid = uid;
        this.taxUid = taxUid;
        this.appliedMoney = appliedMoney;
    }

    @JsonGetter(value="uid")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUid() {
        return this.uid;
    }

    @JsonGetter(value="tax_uid")
    public String getTaxUid() {
        return this.taxUid;
    }

    @JsonGetter(value="applied_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAppliedMoney() {
        return this.appliedMoney;
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.taxUid, this.appliedMoney);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderLineItemAppliedTax)) {
            return false;
        }
        OrderLineItemAppliedTax other = (OrderLineItemAppliedTax)obj;
        return Objects.equals(this.uid, other.uid) && Objects.equals(this.taxUid, other.taxUid) && Objects.equals(this.appliedMoney, other.appliedMoney);
    }

    public String toString() {
        return "OrderLineItemAppliedTax [taxUid=" + this.taxUid + ", uid=" + this.uid + ", appliedMoney=" + this.appliedMoney + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.taxUid).uid(this.getUid()).appliedMoney(this.getAppliedMoney());
        return builder;
    }

    public static class Builder {
        private String taxUid;
        private String uid;
        private Money appliedMoney;

        public Builder(String taxUid) {
            this.taxUid = taxUid;
        }

        public Builder taxUid(String taxUid) {
            this.taxUid = taxUid;
            return this;
        }

        public Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public Builder appliedMoney(Money appliedMoney) {
            this.appliedMoney = appliedMoney;
            return this;
        }

        public OrderLineItemAppliedTax build() {
            return new OrderLineItemAppliedTax(this.taxUid, this.uid, this.appliedMoney);
        }
    }
}

