/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import java.util.Map;
import java.util.Objects;

public class OrderLineItemModifier {
    private final String uid;
    private final String catalogObjectId;
    private final Long catalogVersion;
    private final String name;
    private final String quantity;
    private final Money basePriceMoney;
    private final Money totalPriceMoney;
    private final Map<String, String> metadata;

    @JsonCreator
    public OrderLineItemModifier(@JsonProperty(value="uid") String uid, @JsonProperty(value="catalog_object_id") String catalogObjectId, @JsonProperty(value="catalog_version") Long catalogVersion, @JsonProperty(value="name") String name, @JsonProperty(value="quantity") String quantity, @JsonProperty(value="base_price_money") Money basePriceMoney, @JsonProperty(value="total_price_money") Money totalPriceMoney, @JsonProperty(value="metadata") Map<String, String> metadata) {
        this.uid = uid;
        this.catalogObjectId = catalogObjectId;
        this.catalogVersion = catalogVersion;
        this.name = name;
        this.quantity = quantity;
        this.basePriceMoney = basePriceMoney;
        this.totalPriceMoney = totalPriceMoney;
        this.metadata = metadata;
    }

    @JsonGetter(value="uid")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUid() {
        return this.uid;
    }

    @JsonGetter(value="catalog_object_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCatalogObjectId() {
        return this.catalogObjectId;
    }

    @JsonGetter(value="catalog_version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long getCatalogVersion() {
        return this.catalogVersion;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="quantity")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getQuantity() {
        return this.quantity;
    }

    @JsonGetter(value="base_price_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getBasePriceMoney() {
        return this.basePriceMoney;
    }

    @JsonGetter(value="total_price_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTotalPriceMoney() {
        return this.totalPriceMoney;
    }

    @JsonGetter(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.catalogObjectId, this.catalogVersion, this.name, this.quantity, this.basePriceMoney, this.totalPriceMoney, this.metadata);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderLineItemModifier)) {
            return false;
        }
        OrderLineItemModifier other = (OrderLineItemModifier)obj;
        return Objects.equals(this.uid, other.uid) && Objects.equals(this.catalogObjectId, other.catalogObjectId) && Objects.equals(this.catalogVersion, other.catalogVersion) && Objects.equals(this.name, other.name) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.basePriceMoney, other.basePriceMoney) && Objects.equals(this.totalPriceMoney, other.totalPriceMoney) && Objects.equals(this.metadata, other.metadata);
    }

    public String toString() {
        return "OrderLineItemModifier [uid=" + this.uid + ", catalogObjectId=" + this.catalogObjectId + ", catalogVersion=" + this.catalogVersion + ", name=" + this.name + ", quantity=" + this.quantity + ", basePriceMoney=" + this.basePriceMoney + ", totalPriceMoney=" + this.totalPriceMoney + ", metadata=" + this.metadata + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().uid(this.getUid()).catalogObjectId(this.getCatalogObjectId()).catalogVersion(this.getCatalogVersion()).name(this.getName()).quantity(this.getQuantity()).basePriceMoney(this.getBasePriceMoney()).totalPriceMoney(this.getTotalPriceMoney()).metadata(this.getMetadata());
        return builder;
    }

    public static class Builder {
        private String uid;
        private String catalogObjectId;
        private Long catalogVersion;
        private String name;
        private String quantity;
        private Money basePriceMoney;
        private Money totalPriceMoney;
        private Map<String, String> metadata;

        public Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public Builder catalogObjectId(String catalogObjectId) {
            this.catalogObjectId = catalogObjectId;
            return this;
        }

        public Builder catalogVersion(Long catalogVersion) {
            this.catalogVersion = catalogVersion;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder quantity(String quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder basePriceMoney(Money basePriceMoney) {
            this.basePriceMoney = basePriceMoney;
            return this;
        }

        public Builder totalPriceMoney(Money totalPriceMoney) {
            this.totalPriceMoney = totalPriceMoney;
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public OrderLineItemModifier build() {
            return new OrderLineItemModifier(this.uid, this.catalogObjectId, this.catalogVersion, this.name, this.quantity, this.basePriceMoney, this.totalPriceMoney, this.metadata);
        }
    }
}

