/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.OrderLineItemPricingBlocklistsBlockedDiscount;
import com.squareup.square.models.OrderLineItemPricingBlocklistsBlockedTax;
import java.util.List;
import java.util.Objects;

public class OrderLineItemPricingBlocklists {
    private final List<OrderLineItemPricingBlocklistsBlockedDiscount> blockedDiscounts;
    private final List<OrderLineItemPricingBlocklistsBlockedTax> blockedTaxes;

    @JsonCreator
    public OrderLineItemPricingBlocklists(@JsonProperty(value="blocked_discounts") List<OrderLineItemPricingBlocklistsBlockedDiscount> blockedDiscounts, @JsonProperty(value="blocked_taxes") List<OrderLineItemPricingBlocklistsBlockedTax> blockedTaxes) {
        this.blockedDiscounts = blockedDiscounts;
        this.blockedTaxes = blockedTaxes;
    }

    @JsonGetter(value="blocked_discounts")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<OrderLineItemPricingBlocklistsBlockedDiscount> getBlockedDiscounts() {
        return this.blockedDiscounts;
    }

    @JsonGetter(value="blocked_taxes")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<OrderLineItemPricingBlocklistsBlockedTax> getBlockedTaxes() {
        return this.blockedTaxes;
    }

    public int hashCode() {
        return Objects.hash(this.blockedDiscounts, this.blockedTaxes);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderLineItemPricingBlocklists)) {
            return false;
        }
        OrderLineItemPricingBlocklists other = (OrderLineItemPricingBlocklists)obj;
        return Objects.equals(this.blockedDiscounts, other.blockedDiscounts) && Objects.equals(this.blockedTaxes, other.blockedTaxes);
    }

    public String toString() {
        return "OrderLineItemPricingBlocklists [blockedDiscounts=" + this.blockedDiscounts + ", blockedTaxes=" + this.blockedTaxes + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().blockedDiscounts(this.getBlockedDiscounts()).blockedTaxes(this.getBlockedTaxes());
        return builder;
    }

    public static class Builder {
        private List<OrderLineItemPricingBlocklistsBlockedDiscount> blockedDiscounts;
        private List<OrderLineItemPricingBlocklistsBlockedTax> blockedTaxes;

        public Builder blockedDiscounts(List<OrderLineItemPricingBlocklistsBlockedDiscount> blockedDiscounts) {
            this.blockedDiscounts = blockedDiscounts;
            return this;
        }

        public Builder blockedTaxes(List<OrderLineItemPricingBlocklistsBlockedTax> blockedTaxes) {
            this.blockedTaxes = blockedTaxes;
            return this;
        }

        public OrderLineItemPricingBlocklists build() {
            return new OrderLineItemPricingBlocklists(this.blockedDiscounts, this.blockedTaxes);
        }
    }
}

