/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import java.util.Objects;

public class OrderMoneyAmounts {
    private final Money totalMoney;
    private final Money taxMoney;
    private final Money discountMoney;
    private final Money tipMoney;
    private final Money serviceChargeMoney;

    @JsonCreator
    public OrderMoneyAmounts(@JsonProperty(value="total_money") Money totalMoney, @JsonProperty(value="tax_money") Money taxMoney, @JsonProperty(value="discount_money") Money discountMoney, @JsonProperty(value="tip_money") Money tipMoney, @JsonProperty(value="service_charge_money") Money serviceChargeMoney) {
        this.totalMoney = totalMoney;
        this.taxMoney = taxMoney;
        this.discountMoney = discountMoney;
        this.tipMoney = tipMoney;
        this.serviceChargeMoney = serviceChargeMoney;
    }

    @JsonGetter(value="total_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTotalMoney() {
        return this.totalMoney;
    }

    @JsonGetter(value="tax_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTaxMoney() {
        return this.taxMoney;
    }

    @JsonGetter(value="discount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getDiscountMoney() {
        return this.discountMoney;
    }

    @JsonGetter(value="tip_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTipMoney() {
        return this.tipMoney;
    }

    @JsonGetter(value="service_charge_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getServiceChargeMoney() {
        return this.serviceChargeMoney;
    }

    public int hashCode() {
        return Objects.hash(this.totalMoney, this.taxMoney, this.discountMoney, this.tipMoney, this.serviceChargeMoney);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderMoneyAmounts)) {
            return false;
        }
        OrderMoneyAmounts other = (OrderMoneyAmounts)obj;
        return Objects.equals(this.totalMoney, other.totalMoney) && Objects.equals(this.taxMoney, other.taxMoney) && Objects.equals(this.discountMoney, other.discountMoney) && Objects.equals(this.tipMoney, other.tipMoney) && Objects.equals(this.serviceChargeMoney, other.serviceChargeMoney);
    }

    public String toString() {
        return "OrderMoneyAmounts [totalMoney=" + this.totalMoney + ", taxMoney=" + this.taxMoney + ", discountMoney=" + this.discountMoney + ", tipMoney=" + this.tipMoney + ", serviceChargeMoney=" + this.serviceChargeMoney + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().totalMoney(this.getTotalMoney()).taxMoney(this.getTaxMoney()).discountMoney(this.getDiscountMoney()).tipMoney(this.getTipMoney()).serviceChargeMoney(this.getServiceChargeMoney());
        return builder;
    }

    public static class Builder {
        private Money totalMoney;
        private Money taxMoney;
        private Money discountMoney;
        private Money tipMoney;
        private Money serviceChargeMoney;

        public Builder totalMoney(Money totalMoney) {
            this.totalMoney = totalMoney;
            return this;
        }

        public Builder taxMoney(Money taxMoney) {
            this.taxMoney = taxMoney;
            return this;
        }

        public Builder discountMoney(Money discountMoney) {
            this.discountMoney = discountMoney;
            return this;
        }

        public Builder tipMoney(Money tipMoney) {
            this.tipMoney = tipMoney;
            return this;
        }

        public Builder serviceChargeMoney(Money serviceChargeMoney) {
            this.serviceChargeMoney = serviceChargeMoney;
            return this;
        }

        public OrderMoneyAmounts build() {
            return new OrderMoneyAmounts(this.totalMoney, this.taxMoney, this.discountMoney, this.tipMoney, this.serviceChargeMoney);
        }
    }
}

