/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class OrderPricingOptions {
    private final Boolean autoApplyDiscounts;
    private final Boolean autoApplyTaxes;

    @JsonCreator
    public OrderPricingOptions(@JsonProperty(value="auto_apply_discounts") Boolean autoApplyDiscounts, @JsonProperty(value="auto_apply_taxes") Boolean autoApplyTaxes) {
        this.autoApplyDiscounts = autoApplyDiscounts;
        this.autoApplyTaxes = autoApplyTaxes;
    }

    @JsonGetter(value="auto_apply_discounts")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getAutoApplyDiscounts() {
        return this.autoApplyDiscounts;
    }

    @JsonGetter(value="auto_apply_taxes")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getAutoApplyTaxes() {
        return this.autoApplyTaxes;
    }

    public int hashCode() {
        return Objects.hash(this.autoApplyDiscounts, this.autoApplyTaxes);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderPricingOptions)) {
            return false;
        }
        OrderPricingOptions other = (OrderPricingOptions)obj;
        return Objects.equals(this.autoApplyDiscounts, other.autoApplyDiscounts) && Objects.equals(this.autoApplyTaxes, other.autoApplyTaxes);
    }

    public String toString() {
        return "OrderPricingOptions [autoApplyDiscounts=" + this.autoApplyDiscounts + ", autoApplyTaxes=" + this.autoApplyTaxes + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().autoApplyDiscounts(this.getAutoApplyDiscounts()).autoApplyTaxes(this.getAutoApplyTaxes());
        return builder;
    }

    public static class Builder {
        private Boolean autoApplyDiscounts;
        private Boolean autoApplyTaxes;

        public Builder autoApplyDiscounts(Boolean autoApplyDiscounts) {
            this.autoApplyDiscounts = autoApplyDiscounts;
            return this;
        }

        public Builder autoApplyTaxes(Boolean autoApplyTaxes) {
            this.autoApplyTaxes = autoApplyTaxes;
            return this;
        }

        public OrderPricingOptions build() {
            return new OrderPricingOptions(this.autoApplyDiscounts, this.autoApplyTaxes);
        }
    }
}

