/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.OrderMoneyAmounts;
import com.squareup.square.models.OrderReturnDiscount;
import com.squareup.square.models.OrderReturnLineItem;
import com.squareup.square.models.OrderReturnServiceCharge;
import com.squareup.square.models.OrderReturnTax;
import com.squareup.square.models.OrderRoundingAdjustment;
import java.util.List;
import java.util.Objects;

public class OrderReturn {
    private final String uid;
    private final String sourceOrderId;
    private final List<OrderReturnLineItem> returnLineItems;
    private final List<OrderReturnServiceCharge> returnServiceCharges;
    private final List<OrderReturnTax> returnTaxes;
    private final List<OrderReturnDiscount> returnDiscounts;
    private final OrderRoundingAdjustment roundingAdjustment;
    private final OrderMoneyAmounts returnAmounts;

    @JsonCreator
    public OrderReturn(@JsonProperty(value="uid") String uid, @JsonProperty(value="source_order_id") String sourceOrderId, @JsonProperty(value="return_line_items") List<OrderReturnLineItem> returnLineItems, @JsonProperty(value="return_service_charges") List<OrderReturnServiceCharge> returnServiceCharges, @JsonProperty(value="return_taxes") List<OrderReturnTax> returnTaxes, @JsonProperty(value="return_discounts") List<OrderReturnDiscount> returnDiscounts, @JsonProperty(value="rounding_adjustment") OrderRoundingAdjustment roundingAdjustment, @JsonProperty(value="return_amounts") OrderMoneyAmounts returnAmounts) {
        this.uid = uid;
        this.sourceOrderId = sourceOrderId;
        this.returnLineItems = returnLineItems;
        this.returnServiceCharges = returnServiceCharges;
        this.returnTaxes = returnTaxes;
        this.returnDiscounts = returnDiscounts;
        this.roundingAdjustment = roundingAdjustment;
        this.returnAmounts = returnAmounts;
    }

    @JsonGetter(value="uid")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUid() {
        return this.uid;
    }

    @JsonGetter(value="source_order_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSourceOrderId() {
        return this.sourceOrderId;
    }

    @JsonGetter(value="return_line_items")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<OrderReturnLineItem> getReturnLineItems() {
        return this.returnLineItems;
    }

    @JsonGetter(value="return_service_charges")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<OrderReturnServiceCharge> getReturnServiceCharges() {
        return this.returnServiceCharges;
    }

    @JsonGetter(value="return_taxes")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<OrderReturnTax> getReturnTaxes() {
        return this.returnTaxes;
    }

    @JsonGetter(value="return_discounts")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<OrderReturnDiscount> getReturnDiscounts() {
        return this.returnDiscounts;
    }

    @JsonGetter(value="rounding_adjustment")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public OrderRoundingAdjustment getRoundingAdjustment() {
        return this.roundingAdjustment;
    }

    @JsonGetter(value="return_amounts")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public OrderMoneyAmounts getReturnAmounts() {
        return this.returnAmounts;
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.sourceOrderId, this.returnLineItems, this.returnServiceCharges, this.returnTaxes, this.returnDiscounts, this.roundingAdjustment, this.returnAmounts);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderReturn)) {
            return false;
        }
        OrderReturn other = (OrderReturn)obj;
        return Objects.equals(this.uid, other.uid) && Objects.equals(this.sourceOrderId, other.sourceOrderId) && Objects.equals(this.returnLineItems, other.returnLineItems) && Objects.equals(this.returnServiceCharges, other.returnServiceCharges) && Objects.equals(this.returnTaxes, other.returnTaxes) && Objects.equals(this.returnDiscounts, other.returnDiscounts) && Objects.equals(this.roundingAdjustment, other.roundingAdjustment) && Objects.equals(this.returnAmounts, other.returnAmounts);
    }

    public String toString() {
        return "OrderReturn [uid=" + this.uid + ", sourceOrderId=" + this.sourceOrderId + ", returnLineItems=" + this.returnLineItems + ", returnServiceCharges=" + this.returnServiceCharges + ", returnTaxes=" + this.returnTaxes + ", returnDiscounts=" + this.returnDiscounts + ", roundingAdjustment=" + this.roundingAdjustment + ", returnAmounts=" + this.returnAmounts + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().uid(this.getUid()).sourceOrderId(this.getSourceOrderId()).returnLineItems(this.getReturnLineItems()).returnServiceCharges(this.getReturnServiceCharges()).returnTaxes(this.getReturnTaxes()).returnDiscounts(this.getReturnDiscounts()).roundingAdjustment(this.getRoundingAdjustment()).returnAmounts(this.getReturnAmounts());
        return builder;
    }

    public static class Builder {
        private String uid;
        private String sourceOrderId;
        private List<OrderReturnLineItem> returnLineItems;
        private List<OrderReturnServiceCharge> returnServiceCharges;
        private List<OrderReturnTax> returnTaxes;
        private List<OrderReturnDiscount> returnDiscounts;
        private OrderRoundingAdjustment roundingAdjustment;
        private OrderMoneyAmounts returnAmounts;

        public Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public Builder sourceOrderId(String sourceOrderId) {
            this.sourceOrderId = sourceOrderId;
            return this;
        }

        public Builder returnLineItems(List<OrderReturnLineItem> returnLineItems) {
            this.returnLineItems = returnLineItems;
            return this;
        }

        public Builder returnServiceCharges(List<OrderReturnServiceCharge> returnServiceCharges) {
            this.returnServiceCharges = returnServiceCharges;
            return this;
        }

        public Builder returnTaxes(List<OrderReturnTax> returnTaxes) {
            this.returnTaxes = returnTaxes;
            return this;
        }

        public Builder returnDiscounts(List<OrderReturnDiscount> returnDiscounts) {
            this.returnDiscounts = returnDiscounts;
            return this;
        }

        public Builder roundingAdjustment(OrderRoundingAdjustment roundingAdjustment) {
            this.roundingAdjustment = roundingAdjustment;
            return this;
        }

        public Builder returnAmounts(OrderMoneyAmounts returnAmounts) {
            this.returnAmounts = returnAmounts;
            return this;
        }

        public OrderReturn build() {
            return new OrderReturn(this.uid, this.sourceOrderId, this.returnLineItems, this.returnServiceCharges, this.returnTaxes, this.returnDiscounts, this.roundingAdjustment, this.returnAmounts);
        }
    }
}

