/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import com.squareup.square.models.OrderLineItemAppliedDiscount;
import com.squareup.square.models.OrderLineItemAppliedTax;
import com.squareup.square.models.OrderQuantityUnit;
import com.squareup.square.models.OrderReturnLineItemModifier;
import java.util.List;
import java.util.Objects;

public class OrderReturnLineItem {
    private final String uid;
    private final String sourceLineItemUid;
    private final String name;
    private final String quantity;
    private final OrderQuantityUnit quantityUnit;
    private final String note;
    private final String catalogObjectId;
    private final Long catalogVersion;
    private final String variationName;
    private final String itemType;
    private final List<OrderReturnLineItemModifier> returnModifiers;
    private final List<OrderLineItemAppliedTax> appliedTaxes;
    private final List<OrderLineItemAppliedDiscount> appliedDiscounts;
    private final Money basePriceMoney;
    private final Money variationTotalPriceMoney;
    private final Money grossReturnMoney;
    private final Money totalTaxMoney;
    private final Money totalDiscountMoney;
    private final Money totalMoney;

    @JsonCreator
    public OrderReturnLineItem(@JsonProperty(value="quantity") String quantity, @JsonProperty(value="uid") String uid, @JsonProperty(value="source_line_item_uid") String sourceLineItemUid, @JsonProperty(value="name") String name, @JsonProperty(value="quantity_unit") OrderQuantityUnit quantityUnit, @JsonProperty(value="note") String note, @JsonProperty(value="catalog_object_id") String catalogObjectId, @JsonProperty(value="catalog_version") Long catalogVersion, @JsonProperty(value="variation_name") String variationName, @JsonProperty(value="item_type") String itemType, @JsonProperty(value="return_modifiers") List<OrderReturnLineItemModifier> returnModifiers, @JsonProperty(value="applied_taxes") List<OrderLineItemAppliedTax> appliedTaxes, @JsonProperty(value="applied_discounts") List<OrderLineItemAppliedDiscount> appliedDiscounts, @JsonProperty(value="base_price_money") Money basePriceMoney, @JsonProperty(value="variation_total_price_money") Money variationTotalPriceMoney, @JsonProperty(value="gross_return_money") Money grossReturnMoney, @JsonProperty(value="total_tax_money") Money totalTaxMoney, @JsonProperty(value="total_discount_money") Money totalDiscountMoney, @JsonProperty(value="total_money") Money totalMoney) {
        this.uid = uid;
        this.sourceLineItemUid = sourceLineItemUid;
        this.name = name;
        this.quantity = quantity;
        this.quantityUnit = quantityUnit;
        this.note = note;
        this.catalogObjectId = catalogObjectId;
        this.catalogVersion = catalogVersion;
        this.variationName = variationName;
        this.itemType = itemType;
        this.returnModifiers = returnModifiers;
        this.appliedTaxes = appliedTaxes;
        this.appliedDiscounts = appliedDiscounts;
        this.basePriceMoney = basePriceMoney;
        this.variationTotalPriceMoney = variationTotalPriceMoney;
        this.grossReturnMoney = grossReturnMoney;
        this.totalTaxMoney = totalTaxMoney;
        this.totalDiscountMoney = totalDiscountMoney;
        this.totalMoney = totalMoney;
    }

    @JsonGetter(value="uid")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUid() {
        return this.uid;
    }

    @JsonGetter(value="source_line_item_uid")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSourceLineItemUid() {
        return this.sourceLineItemUid;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="quantity")
    public String getQuantity() {
        return this.quantity;
    }

    @JsonGetter(value="quantity_unit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public OrderQuantityUnit getQuantityUnit() {
        return this.quantityUnit;
    }

    @JsonGetter(value="note")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getNote() {
        return this.note;
    }

    @JsonGetter(value="catalog_object_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCatalogObjectId() {
        return this.catalogObjectId;
    }

    @JsonGetter(value="catalog_version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long getCatalogVersion() {
        return this.catalogVersion;
    }

    @JsonGetter(value="variation_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getVariationName() {
        return this.variationName;
    }

    @JsonGetter(value="item_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getItemType() {
        return this.itemType;
    }

    @JsonGetter(value="return_modifiers")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<OrderReturnLineItemModifier> getReturnModifiers() {
        return this.returnModifiers;
    }

    @JsonGetter(value="applied_taxes")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<OrderLineItemAppliedTax> getAppliedTaxes() {
        return this.appliedTaxes;
    }

    @JsonGetter(value="applied_discounts")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<OrderLineItemAppliedDiscount> getAppliedDiscounts() {
        return this.appliedDiscounts;
    }

    @JsonGetter(value="base_price_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getBasePriceMoney() {
        return this.basePriceMoney;
    }

    @JsonGetter(value="variation_total_price_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getVariationTotalPriceMoney() {
        return this.variationTotalPriceMoney;
    }

    @JsonGetter(value="gross_return_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getGrossReturnMoney() {
        return this.grossReturnMoney;
    }

    @JsonGetter(value="total_tax_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTotalTaxMoney() {
        return this.totalTaxMoney;
    }

    @JsonGetter(value="total_discount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTotalDiscountMoney() {
        return this.totalDiscountMoney;
    }

    @JsonGetter(value="total_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTotalMoney() {
        return this.totalMoney;
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.sourceLineItemUid, this.name, this.quantity, this.quantityUnit, this.note, this.catalogObjectId, this.catalogVersion, this.variationName, this.itemType, this.returnModifiers, this.appliedTaxes, this.appliedDiscounts, this.basePriceMoney, this.variationTotalPriceMoney, this.grossReturnMoney, this.totalTaxMoney, this.totalDiscountMoney, this.totalMoney);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderReturnLineItem)) {
            return false;
        }
        OrderReturnLineItem other = (OrderReturnLineItem)obj;
        return Objects.equals(this.uid, other.uid) && Objects.equals(this.sourceLineItemUid, other.sourceLineItemUid) && Objects.equals(this.name, other.name) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.quantityUnit, other.quantityUnit) && Objects.equals(this.note, other.note) && Objects.equals(this.catalogObjectId, other.catalogObjectId) && Objects.equals(this.catalogVersion, other.catalogVersion) && Objects.equals(this.variationName, other.variationName) && Objects.equals(this.itemType, other.itemType) && Objects.equals(this.returnModifiers, other.returnModifiers) && Objects.equals(this.appliedTaxes, other.appliedTaxes) && Objects.equals(this.appliedDiscounts, other.appliedDiscounts) && Objects.equals(this.basePriceMoney, other.basePriceMoney) && Objects.equals(this.variationTotalPriceMoney, other.variationTotalPriceMoney) && Objects.equals(this.grossReturnMoney, other.grossReturnMoney) && Objects.equals(this.totalTaxMoney, other.totalTaxMoney) && Objects.equals(this.totalDiscountMoney, other.totalDiscountMoney) && Objects.equals(this.totalMoney, other.totalMoney);
    }

    public String toString() {
        return "OrderReturnLineItem [quantity=" + this.quantity + ", uid=" + this.uid + ", sourceLineItemUid=" + this.sourceLineItemUid + ", name=" + this.name + ", quantityUnit=" + this.quantityUnit + ", note=" + this.note + ", catalogObjectId=" + this.catalogObjectId + ", catalogVersion=" + this.catalogVersion + ", variationName=" + this.variationName + ", itemType=" + this.itemType + ", returnModifiers=" + this.returnModifiers + ", appliedTaxes=" + this.appliedTaxes + ", appliedDiscounts=" + this.appliedDiscounts + ", basePriceMoney=" + this.basePriceMoney + ", variationTotalPriceMoney=" + this.variationTotalPriceMoney + ", grossReturnMoney=" + this.grossReturnMoney + ", totalTaxMoney=" + this.totalTaxMoney + ", totalDiscountMoney=" + this.totalDiscountMoney + ", totalMoney=" + this.totalMoney + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.quantity).uid(this.getUid()).sourceLineItemUid(this.getSourceLineItemUid()).name(this.getName()).quantityUnit(this.getQuantityUnit()).note(this.getNote()).catalogObjectId(this.getCatalogObjectId()).catalogVersion(this.getCatalogVersion()).variationName(this.getVariationName()).itemType(this.getItemType()).returnModifiers(this.getReturnModifiers()).appliedTaxes(this.getAppliedTaxes()).appliedDiscounts(this.getAppliedDiscounts()).basePriceMoney(this.getBasePriceMoney()).variationTotalPriceMoney(this.getVariationTotalPriceMoney()).grossReturnMoney(this.getGrossReturnMoney()).totalTaxMoney(this.getTotalTaxMoney()).totalDiscountMoney(this.getTotalDiscountMoney()).totalMoney(this.getTotalMoney());
        return builder;
    }

    public static class Builder {
        private String quantity;
        private String uid;
        private String sourceLineItemUid;
        private String name;
        private OrderQuantityUnit quantityUnit;
        private String note;
        private String catalogObjectId;
        private Long catalogVersion;
        private String variationName;
        private String itemType;
        private List<OrderReturnLineItemModifier> returnModifiers;
        private List<OrderLineItemAppliedTax> appliedTaxes;
        private List<OrderLineItemAppliedDiscount> appliedDiscounts;
        private Money basePriceMoney;
        private Money variationTotalPriceMoney;
        private Money grossReturnMoney;
        private Money totalTaxMoney;
        private Money totalDiscountMoney;
        private Money totalMoney;

        public Builder(String quantity) {
            this.quantity = quantity;
        }

        public Builder quantity(String quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public Builder sourceLineItemUid(String sourceLineItemUid) {
            this.sourceLineItemUid = sourceLineItemUid;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder quantityUnit(OrderQuantityUnit quantityUnit) {
            this.quantityUnit = quantityUnit;
            return this;
        }

        public Builder note(String note) {
            this.note = note;
            return this;
        }

        public Builder catalogObjectId(String catalogObjectId) {
            this.catalogObjectId = catalogObjectId;
            return this;
        }

        public Builder catalogVersion(Long catalogVersion) {
            this.catalogVersion = catalogVersion;
            return this;
        }

        public Builder variationName(String variationName) {
            this.variationName = variationName;
            return this;
        }

        public Builder itemType(String itemType) {
            this.itemType = itemType;
            return this;
        }

        public Builder returnModifiers(List<OrderReturnLineItemModifier> returnModifiers) {
            this.returnModifiers = returnModifiers;
            return this;
        }

        public Builder appliedTaxes(List<OrderLineItemAppliedTax> appliedTaxes) {
            this.appliedTaxes = appliedTaxes;
            return this;
        }

        public Builder appliedDiscounts(List<OrderLineItemAppliedDiscount> appliedDiscounts) {
            this.appliedDiscounts = appliedDiscounts;
            return this;
        }

        public Builder basePriceMoney(Money basePriceMoney) {
            this.basePriceMoney = basePriceMoney;
            return this;
        }

        public Builder variationTotalPriceMoney(Money variationTotalPriceMoney) {
            this.variationTotalPriceMoney = variationTotalPriceMoney;
            return this;
        }

        public Builder grossReturnMoney(Money grossReturnMoney) {
            this.grossReturnMoney = grossReturnMoney;
            return this;
        }

        public Builder totalTaxMoney(Money totalTaxMoney) {
            this.totalTaxMoney = totalTaxMoney;
            return this;
        }

        public Builder totalDiscountMoney(Money totalDiscountMoney) {
            this.totalDiscountMoney = totalDiscountMoney;
            return this;
        }

        public Builder totalMoney(Money totalMoney) {
            this.totalMoney = totalMoney;
            return this;
        }

        public OrderReturnLineItem build() {
            return new OrderReturnLineItem(this.quantity, this.uid, this.sourceLineItemUid, this.name, this.quantityUnit, this.note, this.catalogObjectId, this.catalogVersion, this.variationName, this.itemType, this.returnModifiers, this.appliedTaxes, this.appliedDiscounts, this.basePriceMoney, this.variationTotalPriceMoney, this.grossReturnMoney, this.totalTaxMoney, this.totalDiscountMoney, this.totalMoney);
        }
    }
}

