/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import java.util.Objects;

public class OrderReturnLineItemModifier {
    private final String uid;
    private final String sourceModifierUid;
    private final String catalogObjectId;
    private final Long catalogVersion;
    private final String name;
    private final Money basePriceMoney;
    private final Money totalPriceMoney;

    @JsonCreator
    public OrderReturnLineItemModifier(@JsonProperty(value="uid") String uid, @JsonProperty(value="source_modifier_uid") String sourceModifierUid, @JsonProperty(value="catalog_object_id") String catalogObjectId, @JsonProperty(value="catalog_version") Long catalogVersion, @JsonProperty(value="name") String name, @JsonProperty(value="base_price_money") Money basePriceMoney, @JsonProperty(value="total_price_money") Money totalPriceMoney) {
        this.uid = uid;
        this.sourceModifierUid = sourceModifierUid;
        this.catalogObjectId = catalogObjectId;
        this.catalogVersion = catalogVersion;
        this.name = name;
        this.basePriceMoney = basePriceMoney;
        this.totalPriceMoney = totalPriceMoney;
    }

    @JsonGetter(value="uid")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUid() {
        return this.uid;
    }

    @JsonGetter(value="source_modifier_uid")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSourceModifierUid() {
        return this.sourceModifierUid;
    }

    @JsonGetter(value="catalog_object_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCatalogObjectId() {
        return this.catalogObjectId;
    }

    @JsonGetter(value="catalog_version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long getCatalogVersion() {
        return this.catalogVersion;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="base_price_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getBasePriceMoney() {
        return this.basePriceMoney;
    }

    @JsonGetter(value="total_price_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTotalPriceMoney() {
        return this.totalPriceMoney;
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.sourceModifierUid, this.catalogObjectId, this.catalogVersion, this.name, this.basePriceMoney, this.totalPriceMoney);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderReturnLineItemModifier)) {
            return false;
        }
        OrderReturnLineItemModifier other = (OrderReturnLineItemModifier)obj;
        return Objects.equals(this.uid, other.uid) && Objects.equals(this.sourceModifierUid, other.sourceModifierUid) && Objects.equals(this.catalogObjectId, other.catalogObjectId) && Objects.equals(this.catalogVersion, other.catalogVersion) && Objects.equals(this.name, other.name) && Objects.equals(this.basePriceMoney, other.basePriceMoney) && Objects.equals(this.totalPriceMoney, other.totalPriceMoney);
    }

    public String toString() {
        return "OrderReturnLineItemModifier [uid=" + this.uid + ", sourceModifierUid=" + this.sourceModifierUid + ", catalogObjectId=" + this.catalogObjectId + ", catalogVersion=" + this.catalogVersion + ", name=" + this.name + ", basePriceMoney=" + this.basePriceMoney + ", totalPriceMoney=" + this.totalPriceMoney + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().uid(this.getUid()).sourceModifierUid(this.getSourceModifierUid()).catalogObjectId(this.getCatalogObjectId()).catalogVersion(this.getCatalogVersion()).name(this.getName()).basePriceMoney(this.getBasePriceMoney()).totalPriceMoney(this.getTotalPriceMoney());
        return builder;
    }

    public static class Builder {
        private String uid;
        private String sourceModifierUid;
        private String catalogObjectId;
        private Long catalogVersion;
        private String name;
        private Money basePriceMoney;
        private Money totalPriceMoney;

        public Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public Builder sourceModifierUid(String sourceModifierUid) {
            this.sourceModifierUid = sourceModifierUid;
            return this;
        }

        public Builder catalogObjectId(String catalogObjectId) {
            this.catalogObjectId = catalogObjectId;
            return this;
        }

        public Builder catalogVersion(Long catalogVersion) {
            this.catalogVersion = catalogVersion;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder basePriceMoney(Money basePriceMoney) {
            this.basePriceMoney = basePriceMoney;
            return this;
        }

        public Builder totalPriceMoney(Money totalPriceMoney) {
            this.totalPriceMoney = totalPriceMoney;
            return this;
        }

        public OrderReturnLineItemModifier build() {
            return new OrderReturnLineItemModifier(this.uid, this.sourceModifierUid, this.catalogObjectId, this.catalogVersion, this.name, this.basePriceMoney, this.totalPriceMoney);
        }
    }
}

