/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import com.squareup.square.models.OrderLineItemAppliedTax;
import java.util.List;
import java.util.Objects;

public class OrderReturnServiceCharge {
    private final String uid;
    private final String sourceServiceChargeUid;
    private final String name;
    private final String catalogObjectId;
    private final Long catalogVersion;
    private final String percentage;
    private final Money amountMoney;
    private final Money appliedMoney;
    private final Money totalMoney;
    private final Money totalTaxMoney;
    private final String calculationPhase;
    private final Boolean taxable;
    private final List<OrderLineItemAppliedTax> appliedTaxes;

    @JsonCreator
    public OrderReturnServiceCharge(@JsonProperty(value="uid") String uid, @JsonProperty(value="source_service_charge_uid") String sourceServiceChargeUid, @JsonProperty(value="name") String name, @JsonProperty(value="catalog_object_id") String catalogObjectId, @JsonProperty(value="catalog_version") Long catalogVersion, @JsonProperty(value="percentage") String percentage, @JsonProperty(value="amount_money") Money amountMoney, @JsonProperty(value="applied_money") Money appliedMoney, @JsonProperty(value="total_money") Money totalMoney, @JsonProperty(value="total_tax_money") Money totalTaxMoney, @JsonProperty(value="calculation_phase") String calculationPhase, @JsonProperty(value="taxable") Boolean taxable, @JsonProperty(value="applied_taxes") List<OrderLineItemAppliedTax> appliedTaxes) {
        this.uid = uid;
        this.sourceServiceChargeUid = sourceServiceChargeUid;
        this.name = name;
        this.catalogObjectId = catalogObjectId;
        this.catalogVersion = catalogVersion;
        this.percentage = percentage;
        this.amountMoney = amountMoney;
        this.appliedMoney = appliedMoney;
        this.totalMoney = totalMoney;
        this.totalTaxMoney = totalTaxMoney;
        this.calculationPhase = calculationPhase;
        this.taxable = taxable;
        this.appliedTaxes = appliedTaxes;
    }

    @JsonGetter(value="uid")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUid() {
        return this.uid;
    }

    @JsonGetter(value="source_service_charge_uid")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSourceServiceChargeUid() {
        return this.sourceServiceChargeUid;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="catalog_object_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCatalogObjectId() {
        return this.catalogObjectId;
    }

    @JsonGetter(value="catalog_version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long getCatalogVersion() {
        return this.catalogVersion;
    }

    @JsonGetter(value="percentage")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPercentage() {
        return this.percentage;
    }

    @JsonGetter(value="amount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonGetter(value="applied_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAppliedMoney() {
        return this.appliedMoney;
    }

    @JsonGetter(value="total_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTotalMoney() {
        return this.totalMoney;
    }

    @JsonGetter(value="total_tax_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTotalTaxMoney() {
        return this.totalTaxMoney;
    }

    @JsonGetter(value="calculation_phase")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCalculationPhase() {
        return this.calculationPhase;
    }

    @JsonGetter(value="taxable")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getTaxable() {
        return this.taxable;
    }

    @JsonGetter(value="applied_taxes")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<OrderLineItemAppliedTax> getAppliedTaxes() {
        return this.appliedTaxes;
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.sourceServiceChargeUid, this.name, this.catalogObjectId, this.catalogVersion, this.percentage, this.amountMoney, this.appliedMoney, this.totalMoney, this.totalTaxMoney, this.calculationPhase, this.taxable, this.appliedTaxes);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderReturnServiceCharge)) {
            return false;
        }
        OrderReturnServiceCharge other = (OrderReturnServiceCharge)obj;
        return Objects.equals(this.uid, other.uid) && Objects.equals(this.sourceServiceChargeUid, other.sourceServiceChargeUid) && Objects.equals(this.name, other.name) && Objects.equals(this.catalogObjectId, other.catalogObjectId) && Objects.equals(this.catalogVersion, other.catalogVersion) && Objects.equals(this.percentage, other.percentage) && Objects.equals(this.amountMoney, other.amountMoney) && Objects.equals(this.appliedMoney, other.appliedMoney) && Objects.equals(this.totalMoney, other.totalMoney) && Objects.equals(this.totalTaxMoney, other.totalTaxMoney) && Objects.equals(this.calculationPhase, other.calculationPhase) && Objects.equals(this.taxable, other.taxable) && Objects.equals(this.appliedTaxes, other.appliedTaxes);
    }

    public String toString() {
        return "OrderReturnServiceCharge [uid=" + this.uid + ", sourceServiceChargeUid=" + this.sourceServiceChargeUid + ", name=" + this.name + ", catalogObjectId=" + this.catalogObjectId + ", catalogVersion=" + this.catalogVersion + ", percentage=" + this.percentage + ", amountMoney=" + this.amountMoney + ", appliedMoney=" + this.appliedMoney + ", totalMoney=" + this.totalMoney + ", totalTaxMoney=" + this.totalTaxMoney + ", calculationPhase=" + this.calculationPhase + ", taxable=" + this.taxable + ", appliedTaxes=" + this.appliedTaxes + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().uid(this.getUid()).sourceServiceChargeUid(this.getSourceServiceChargeUid()).name(this.getName()).catalogObjectId(this.getCatalogObjectId()).catalogVersion(this.getCatalogVersion()).percentage(this.getPercentage()).amountMoney(this.getAmountMoney()).appliedMoney(this.getAppliedMoney()).totalMoney(this.getTotalMoney()).totalTaxMoney(this.getTotalTaxMoney()).calculationPhase(this.getCalculationPhase()).taxable(this.getTaxable()).appliedTaxes(this.getAppliedTaxes());
        return builder;
    }

    public static class Builder {
        private String uid;
        private String sourceServiceChargeUid;
        private String name;
        private String catalogObjectId;
        private Long catalogVersion;
        private String percentage;
        private Money amountMoney;
        private Money appliedMoney;
        private Money totalMoney;
        private Money totalTaxMoney;
        private String calculationPhase;
        private Boolean taxable;
        private List<OrderLineItemAppliedTax> appliedTaxes;

        public Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public Builder sourceServiceChargeUid(String sourceServiceChargeUid) {
            this.sourceServiceChargeUid = sourceServiceChargeUid;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder catalogObjectId(String catalogObjectId) {
            this.catalogObjectId = catalogObjectId;
            return this;
        }

        public Builder catalogVersion(Long catalogVersion) {
            this.catalogVersion = catalogVersion;
            return this;
        }

        public Builder percentage(String percentage) {
            this.percentage = percentage;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder appliedMoney(Money appliedMoney) {
            this.appliedMoney = appliedMoney;
            return this;
        }

        public Builder totalMoney(Money totalMoney) {
            this.totalMoney = totalMoney;
            return this;
        }

        public Builder totalTaxMoney(Money totalTaxMoney) {
            this.totalTaxMoney = totalTaxMoney;
            return this;
        }

        public Builder calculationPhase(String calculationPhase) {
            this.calculationPhase = calculationPhase;
            return this;
        }

        public Builder taxable(Boolean taxable) {
            this.taxable = taxable;
            return this;
        }

        public Builder appliedTaxes(List<OrderLineItemAppliedTax> appliedTaxes) {
            this.appliedTaxes = appliedTaxes;
            return this;
        }

        public OrderReturnServiceCharge build() {
            return new OrderReturnServiceCharge(this.uid, this.sourceServiceChargeUid, this.name, this.catalogObjectId, this.catalogVersion, this.percentage, this.amountMoney, this.appliedMoney, this.totalMoney, this.totalTaxMoney, this.calculationPhase, this.taxable, this.appliedTaxes);
        }
    }
}

