/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import java.util.Objects;

public class OrderReturnTax {
    private final String uid;
    private final String sourceTaxUid;
    private final String catalogObjectId;
    private final Long catalogVersion;
    private final String name;
    private final String type;
    private final String percentage;
    private final Money appliedMoney;
    private final String scope;

    @JsonCreator
    public OrderReturnTax(@JsonProperty(value="uid") String uid, @JsonProperty(value="source_tax_uid") String sourceTaxUid, @JsonProperty(value="catalog_object_id") String catalogObjectId, @JsonProperty(value="catalog_version") Long catalogVersion, @JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="percentage") String percentage, @JsonProperty(value="applied_money") Money appliedMoney, @JsonProperty(value="scope") String scope) {
        this.uid = uid;
        this.sourceTaxUid = sourceTaxUid;
        this.catalogObjectId = catalogObjectId;
        this.catalogVersion = catalogVersion;
        this.name = name;
        this.type = type;
        this.percentage = percentage;
        this.appliedMoney = appliedMoney;
        this.scope = scope;
    }

    @JsonGetter(value="uid")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUid() {
        return this.uid;
    }

    @JsonGetter(value="source_tax_uid")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSourceTaxUid() {
        return this.sourceTaxUid;
    }

    @JsonGetter(value="catalog_object_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCatalogObjectId() {
        return this.catalogObjectId;
    }

    @JsonGetter(value="catalog_version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long getCatalogVersion() {
        return this.catalogVersion;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getType() {
        return this.type;
    }

    @JsonGetter(value="percentage")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPercentage() {
        return this.percentage;
    }

    @JsonGetter(value="applied_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAppliedMoney() {
        return this.appliedMoney;
    }

    @JsonGetter(value="scope")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getScope() {
        return this.scope;
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.sourceTaxUid, this.catalogObjectId, this.catalogVersion, this.name, this.type, this.percentage, this.appliedMoney, this.scope);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderReturnTax)) {
            return false;
        }
        OrderReturnTax other = (OrderReturnTax)obj;
        return Objects.equals(this.uid, other.uid) && Objects.equals(this.sourceTaxUid, other.sourceTaxUid) && Objects.equals(this.catalogObjectId, other.catalogObjectId) && Objects.equals(this.catalogVersion, other.catalogVersion) && Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type) && Objects.equals(this.percentage, other.percentage) && Objects.equals(this.appliedMoney, other.appliedMoney) && Objects.equals(this.scope, other.scope);
    }

    public String toString() {
        return "OrderReturnTax [uid=" + this.uid + ", sourceTaxUid=" + this.sourceTaxUid + ", catalogObjectId=" + this.catalogObjectId + ", catalogVersion=" + this.catalogVersion + ", name=" + this.name + ", type=" + this.type + ", percentage=" + this.percentage + ", appliedMoney=" + this.appliedMoney + ", scope=" + this.scope + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().uid(this.getUid()).sourceTaxUid(this.getSourceTaxUid()).catalogObjectId(this.getCatalogObjectId()).catalogVersion(this.getCatalogVersion()).name(this.getName()).type(this.getType()).percentage(this.getPercentage()).appliedMoney(this.getAppliedMoney()).scope(this.getScope());
        return builder;
    }

    public static class Builder {
        private String uid;
        private String sourceTaxUid;
        private String catalogObjectId;
        private Long catalogVersion;
        private String name;
        private String type;
        private String percentage;
        private Money appliedMoney;
        private String scope;

        public Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public Builder sourceTaxUid(String sourceTaxUid) {
            this.sourceTaxUid = sourceTaxUid;
            return this;
        }

        public Builder catalogObjectId(String catalogObjectId) {
            this.catalogObjectId = catalogObjectId;
            return this;
        }

        public Builder catalogVersion(Long catalogVersion) {
            this.catalogVersion = catalogVersion;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder percentage(String percentage) {
            this.percentage = percentage;
            return this;
        }

        public Builder appliedMoney(Money appliedMoney) {
            this.appliedMoney = appliedMoney;
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public OrderReturnTax build() {
            return new OrderReturnTax(this.uid, this.sourceTaxUid, this.catalogObjectId, this.catalogVersion, this.name, this.type, this.percentage, this.appliedMoney, this.scope);
        }
    }
}

