/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class OrderReward {
    private final String id;
    private final String rewardTierId;

    @JsonCreator
    public OrderReward(@JsonProperty(value="id") String id, @JsonProperty(value="reward_tier_id") String rewardTierId) {
        this.id = id;
        this.rewardTierId = rewardTierId;
    }

    @JsonGetter(value="id")
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="reward_tier_id")
    public String getRewardTierId() {
        return this.rewardTierId;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.rewardTierId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderReward)) {
            return false;
        }
        OrderReward other = (OrderReward)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.rewardTierId, other.rewardTierId);
    }

    public String toString() {
        return "OrderReward [id=" + this.id + ", rewardTierId=" + this.rewardTierId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.id, this.rewardTierId);
        return builder;
    }

    public static class Builder {
        private String id;
        private String rewardTierId;

        public Builder(String id, String rewardTierId) {
            this.id = id;
            this.rewardTierId = rewardTierId;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder rewardTierId(String rewardTierId) {
            this.rewardTierId = rewardTierId;
            return this;
        }

        public OrderReward build() {
            return new OrderReward(this.id, this.rewardTierId);
        }
    }
}

