/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import java.util.Objects;

public class OrderRoundingAdjustment {
    private final String uid;
    private final String name;
    private final Money amountMoney;

    @JsonCreator
    public OrderRoundingAdjustment(@JsonProperty(value="uid") String uid, @JsonProperty(value="name") String name, @JsonProperty(value="amount_money") Money amountMoney) {
        this.uid = uid;
        this.name = name;
        this.amountMoney = amountMoney;
    }

    @JsonGetter(value="uid")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUid() {
        return this.uid;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="amount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.name, this.amountMoney);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderRoundingAdjustment)) {
            return false;
        }
        OrderRoundingAdjustment other = (OrderRoundingAdjustment)obj;
        return Objects.equals(this.uid, other.uid) && Objects.equals(this.name, other.name) && Objects.equals(this.amountMoney, other.amountMoney);
    }

    public String toString() {
        return "OrderRoundingAdjustment [uid=" + this.uid + ", name=" + this.name + ", amountMoney=" + this.amountMoney + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().uid(this.getUid()).name(this.getName()).amountMoney(this.getAmountMoney());
        return builder;
    }

    public static class Builder {
        private String uid;
        private String name;
        private Money amountMoney;

        public Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public OrderRoundingAdjustment build() {
            return new OrderRoundingAdjustment(this.uid, this.name, this.amountMoney);
        }
    }
}

