/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import com.squareup.square.models.OrderLineItemAppliedTax;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class OrderServiceCharge {
    private final String uid;
    private final String name;
    private final String catalogObjectId;
    private final Long catalogVersion;
    private final String percentage;
    private final Money amountMoney;
    private final Money appliedMoney;
    private final Money totalMoney;
    private final Money totalTaxMoney;
    private final String calculationPhase;
    private final Boolean taxable;
    private final List<OrderLineItemAppliedTax> appliedTaxes;
    private final Map<String, String> metadata;
    private final String type;

    @JsonCreator
    public OrderServiceCharge(@JsonProperty(value="uid") String uid, @JsonProperty(value="name") String name, @JsonProperty(value="catalog_object_id") String catalogObjectId, @JsonProperty(value="catalog_version") Long catalogVersion, @JsonProperty(value="percentage") String percentage, @JsonProperty(value="amount_money") Money amountMoney, @JsonProperty(value="applied_money") Money appliedMoney, @JsonProperty(value="total_money") Money totalMoney, @JsonProperty(value="total_tax_money") Money totalTaxMoney, @JsonProperty(value="calculation_phase") String calculationPhase, @JsonProperty(value="taxable") Boolean taxable, @JsonProperty(value="applied_taxes") List<OrderLineItemAppliedTax> appliedTaxes, @JsonProperty(value="metadata") Map<String, String> metadata, @JsonProperty(value="type") String type) {
        this.uid = uid;
        this.name = name;
        this.catalogObjectId = catalogObjectId;
        this.catalogVersion = catalogVersion;
        this.percentage = percentage;
        this.amountMoney = amountMoney;
        this.appliedMoney = appliedMoney;
        this.totalMoney = totalMoney;
        this.totalTaxMoney = totalTaxMoney;
        this.calculationPhase = calculationPhase;
        this.taxable = taxable;
        this.appliedTaxes = appliedTaxes;
        this.metadata = metadata;
        this.type = type;
    }

    @JsonGetter(value="uid")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUid() {
        return this.uid;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="catalog_object_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCatalogObjectId() {
        return this.catalogObjectId;
    }

    @JsonGetter(value="catalog_version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long getCatalogVersion() {
        return this.catalogVersion;
    }

    @JsonGetter(value="percentage")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPercentage() {
        return this.percentage;
    }

    @JsonGetter(value="amount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonGetter(value="applied_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAppliedMoney() {
        return this.appliedMoney;
    }

    @JsonGetter(value="total_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTotalMoney() {
        return this.totalMoney;
    }

    @JsonGetter(value="total_tax_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTotalTaxMoney() {
        return this.totalTaxMoney;
    }

    @JsonGetter(value="calculation_phase")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCalculationPhase() {
        return this.calculationPhase;
    }

    @JsonGetter(value="taxable")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getTaxable() {
        return this.taxable;
    }

    @JsonGetter(value="applied_taxes")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<OrderLineItemAppliedTax> getAppliedTaxes() {
        return this.appliedTaxes;
    }

    @JsonGetter(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonGetter(value="type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.name, this.catalogObjectId, this.catalogVersion, this.percentage, this.amountMoney, this.appliedMoney, this.totalMoney, this.totalTaxMoney, this.calculationPhase, this.taxable, this.appliedTaxes, this.metadata, this.type);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderServiceCharge)) {
            return false;
        }
        OrderServiceCharge other = (OrderServiceCharge)obj;
        return Objects.equals(this.uid, other.uid) && Objects.equals(this.name, other.name) && Objects.equals(this.catalogObjectId, other.catalogObjectId) && Objects.equals(this.catalogVersion, other.catalogVersion) && Objects.equals(this.percentage, other.percentage) && Objects.equals(this.amountMoney, other.amountMoney) && Objects.equals(this.appliedMoney, other.appliedMoney) && Objects.equals(this.totalMoney, other.totalMoney) && Objects.equals(this.totalTaxMoney, other.totalTaxMoney) && Objects.equals(this.calculationPhase, other.calculationPhase) && Objects.equals(this.taxable, other.taxable) && Objects.equals(this.appliedTaxes, other.appliedTaxes) && Objects.equals(this.metadata, other.metadata) && Objects.equals(this.type, other.type);
    }

    public String toString() {
        return "OrderServiceCharge [uid=" + this.uid + ", name=" + this.name + ", catalogObjectId=" + this.catalogObjectId + ", catalogVersion=" + this.catalogVersion + ", percentage=" + this.percentage + ", amountMoney=" + this.amountMoney + ", appliedMoney=" + this.appliedMoney + ", totalMoney=" + this.totalMoney + ", totalTaxMoney=" + this.totalTaxMoney + ", calculationPhase=" + this.calculationPhase + ", taxable=" + this.taxable + ", appliedTaxes=" + this.appliedTaxes + ", metadata=" + this.metadata + ", type=" + this.type + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().uid(this.getUid()).name(this.getName()).catalogObjectId(this.getCatalogObjectId()).catalogVersion(this.getCatalogVersion()).percentage(this.getPercentage()).amountMoney(this.getAmountMoney()).appliedMoney(this.getAppliedMoney()).totalMoney(this.getTotalMoney()).totalTaxMoney(this.getTotalTaxMoney()).calculationPhase(this.getCalculationPhase()).taxable(this.getTaxable()).appliedTaxes(this.getAppliedTaxes()).metadata(this.getMetadata()).type(this.getType());
        return builder;
    }

    public static class Builder {
        private String uid;
        private String name;
        private String catalogObjectId;
        private Long catalogVersion;
        private String percentage;
        private Money amountMoney;
        private Money appliedMoney;
        private Money totalMoney;
        private Money totalTaxMoney;
        private String calculationPhase;
        private Boolean taxable;
        private List<OrderLineItemAppliedTax> appliedTaxes;
        private Map<String, String> metadata;
        private String type;

        public Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder catalogObjectId(String catalogObjectId) {
            this.catalogObjectId = catalogObjectId;
            return this;
        }

        public Builder catalogVersion(Long catalogVersion) {
            this.catalogVersion = catalogVersion;
            return this;
        }

        public Builder percentage(String percentage) {
            this.percentage = percentage;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder appliedMoney(Money appliedMoney) {
            this.appliedMoney = appliedMoney;
            return this;
        }

        public Builder totalMoney(Money totalMoney) {
            this.totalMoney = totalMoney;
            return this;
        }

        public Builder totalTaxMoney(Money totalTaxMoney) {
            this.totalTaxMoney = totalTaxMoney;
            return this;
        }

        public Builder calculationPhase(String calculationPhase) {
            this.calculationPhase = calculationPhase;
            return this;
        }

        public Builder taxable(Boolean taxable) {
            this.taxable = taxable;
            return this;
        }

        public Builder appliedTaxes(List<OrderLineItemAppliedTax> appliedTaxes) {
            this.appliedTaxes = appliedTaxes;
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public OrderServiceCharge build() {
            return new OrderServiceCharge(this.uid, this.name, this.catalogObjectId, this.catalogVersion, this.percentage, this.amountMoney, this.appliedMoney, this.totalMoney, this.totalTaxMoney, this.calculationPhase, this.taxable, this.appliedTaxes, this.metadata, this.type);
        }
    }
}

