/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class PauseSubscriptionRequest {
    private final String pauseEffectiveDate;
    private final Long pauseCycleDuration;
    private final String resumeEffectiveDate;
    private final String resumeChangeTiming;
    private final String pauseReason;

    @JsonCreator
    public PauseSubscriptionRequest(@JsonProperty(value="pause_effective_date") String pauseEffectiveDate, @JsonProperty(value="pause_cycle_duration") Long pauseCycleDuration, @JsonProperty(value="resume_effective_date") String resumeEffectiveDate, @JsonProperty(value="resume_change_timing") String resumeChangeTiming, @JsonProperty(value="pause_reason") String pauseReason) {
        this.pauseEffectiveDate = pauseEffectiveDate;
        this.pauseCycleDuration = pauseCycleDuration;
        this.resumeEffectiveDate = resumeEffectiveDate;
        this.resumeChangeTiming = resumeChangeTiming;
        this.pauseReason = pauseReason;
    }

    @JsonGetter(value="pause_effective_date")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPauseEffectiveDate() {
        return this.pauseEffectiveDate;
    }

    @JsonGetter(value="pause_cycle_duration")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long getPauseCycleDuration() {
        return this.pauseCycleDuration;
    }

    @JsonGetter(value="resume_effective_date")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getResumeEffectiveDate() {
        return this.resumeEffectiveDate;
    }

    @JsonGetter(value="resume_change_timing")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getResumeChangeTiming() {
        return this.resumeChangeTiming;
    }

    @JsonGetter(value="pause_reason")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPauseReason() {
        return this.pauseReason;
    }

    public int hashCode() {
        return Objects.hash(this.pauseEffectiveDate, this.pauseCycleDuration, this.resumeEffectiveDate, this.resumeChangeTiming, this.pauseReason);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PauseSubscriptionRequest)) {
            return false;
        }
        PauseSubscriptionRequest other = (PauseSubscriptionRequest)obj;
        return Objects.equals(this.pauseEffectiveDate, other.pauseEffectiveDate) && Objects.equals(this.pauseCycleDuration, other.pauseCycleDuration) && Objects.equals(this.resumeEffectiveDate, other.resumeEffectiveDate) && Objects.equals(this.resumeChangeTiming, other.resumeChangeTiming) && Objects.equals(this.pauseReason, other.pauseReason);
    }

    public String toString() {
        return "PauseSubscriptionRequest [pauseEffectiveDate=" + this.pauseEffectiveDate + ", pauseCycleDuration=" + this.pauseCycleDuration + ", resumeEffectiveDate=" + this.resumeEffectiveDate + ", resumeChangeTiming=" + this.resumeChangeTiming + ", pauseReason=" + this.pauseReason + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().pauseEffectiveDate(this.getPauseEffectiveDate()).pauseCycleDuration(this.getPauseCycleDuration()).resumeEffectiveDate(this.getResumeEffectiveDate()).resumeChangeTiming(this.getResumeChangeTiming()).pauseReason(this.getPauseReason());
        return builder;
    }

    public static class Builder {
        private String pauseEffectiveDate;
        private Long pauseCycleDuration;
        private String resumeEffectiveDate;
        private String resumeChangeTiming;
        private String pauseReason;

        public Builder pauseEffectiveDate(String pauseEffectiveDate) {
            this.pauseEffectiveDate = pauseEffectiveDate;
            return this;
        }

        public Builder pauseCycleDuration(Long pauseCycleDuration) {
            this.pauseCycleDuration = pauseCycleDuration;
            return this;
        }

        public Builder resumeEffectiveDate(String resumeEffectiveDate) {
            this.resumeEffectiveDate = resumeEffectiveDate;
            return this;
        }

        public Builder resumeChangeTiming(String resumeChangeTiming) {
            this.resumeChangeTiming = resumeChangeTiming;
            return this;
        }

        public Builder pauseReason(String pauseReason) {
            this.pauseReason = pauseReason;
            return this;
        }

        public PauseSubscriptionRequest build() {
            return new PauseSubscriptionRequest(this.pauseEffectiveDate, this.pauseCycleDuration, this.resumeEffectiveDate, this.resumeChangeTiming, this.pauseReason);
        }
    }
}

