/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public class PayOrderRequest {
    private final String idempotencyKey;
    private final Integer orderVersion;
    private final List<String> paymentIds;

    @JsonCreator
    public PayOrderRequest(@JsonProperty(value="idempotency_key") String idempotencyKey, @JsonProperty(value="order_version") Integer orderVersion, @JsonProperty(value="payment_ids") List<String> paymentIds) {
        this.idempotencyKey = idempotencyKey;
        this.orderVersion = orderVersion;
        this.paymentIds = paymentIds;
    }

    @JsonGetter(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonGetter(value="order_version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getOrderVersion() {
        return this.orderVersion;
    }

    @JsonGetter(value="payment_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getPaymentIds() {
        return this.paymentIds;
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.orderVersion, this.paymentIds);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PayOrderRequest)) {
            return false;
        }
        PayOrderRequest other = (PayOrderRequest)obj;
        return Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.orderVersion, other.orderVersion) && Objects.equals(this.paymentIds, other.paymentIds);
    }

    public String toString() {
        return "PayOrderRequest [idempotencyKey=" + this.idempotencyKey + ", orderVersion=" + this.orderVersion + ", paymentIds=" + this.paymentIds + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.idempotencyKey).orderVersion(this.getOrderVersion()).paymentIds(this.getPaymentIds());
        return builder;
    }

    public static class Builder {
        private String idempotencyKey;
        private Integer orderVersion;
        private List<String> paymentIds;

        public Builder(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Builder orderVersion(Integer orderVersion) {
            this.orderVersion = orderVersion;
            return this;
        }

        public Builder paymentIds(List<String> paymentIds) {
            this.paymentIds = paymentIds;
            return this;
        }

        public PayOrderRequest build() {
            return new PayOrderRequest(this.idempotencyKey, this.orderVersion, this.paymentIds);
        }
    }
}

