/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class PaymentOptions {
    private final Boolean autocomplete;
    private final String delayDuration;
    private final Boolean acceptPartialAuthorization;

    @JsonCreator
    public PaymentOptions(@JsonProperty(value="autocomplete") Boolean autocomplete, @JsonProperty(value="delay_duration") String delayDuration, @JsonProperty(value="accept_partial_authorization") Boolean acceptPartialAuthorization) {
        this.autocomplete = autocomplete;
        this.delayDuration = delayDuration;
        this.acceptPartialAuthorization = acceptPartialAuthorization;
    }

    @JsonGetter(value="autocomplete")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getAutocomplete() {
        return this.autocomplete;
    }

    @JsonGetter(value="delay_duration")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDelayDuration() {
        return this.delayDuration;
    }

    @JsonGetter(value="accept_partial_authorization")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getAcceptPartialAuthorization() {
        return this.acceptPartialAuthorization;
    }

    public int hashCode() {
        return Objects.hash(this.autocomplete, this.delayDuration, this.acceptPartialAuthorization);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PaymentOptions)) {
            return false;
        }
        PaymentOptions other = (PaymentOptions)obj;
        return Objects.equals(this.autocomplete, other.autocomplete) && Objects.equals(this.delayDuration, other.delayDuration) && Objects.equals(this.acceptPartialAuthorization, other.acceptPartialAuthorization);
    }

    public String toString() {
        return "PaymentOptions [autocomplete=" + this.autocomplete + ", delayDuration=" + this.delayDuration + ", acceptPartialAuthorization=" + this.acceptPartialAuthorization + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().autocomplete(this.getAutocomplete()).delayDuration(this.getDelayDuration()).acceptPartialAuthorization(this.getAcceptPartialAuthorization());
        return builder;
    }

    public static class Builder {
        private Boolean autocomplete;
        private String delayDuration;
        private Boolean acceptPartialAuthorization;

        public Builder autocomplete(Boolean autocomplete) {
            this.autocomplete = autocomplete;
            return this;
        }

        public Builder delayDuration(String delayDuration) {
            this.delayDuration = delayDuration;
            return this;
        }

        public Builder acceptPartialAuthorization(Boolean acceptPartialAuthorization) {
            this.acceptPartialAuthorization = acceptPartialAuthorization;
            return this;
        }

        public PaymentOptions build() {
            return new PaymentOptions(this.autocomplete, this.delayDuration, this.acceptPartialAuthorization);
        }
    }
}

