/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import com.squareup.square.models.ProcessingFee;
import java.util.List;
import java.util.Objects;

public class PaymentRefund {
    private final String id;
    private final String status;
    private final String locationId;
    private final Money amountMoney;
    private final Money appFeeMoney;
    private final List<ProcessingFee> processingFee;
    private final String paymentId;
    private final String orderId;
    private final String reason;
    private final String createdAt;
    private final String updatedAt;
    private final String teamMemberId;

    @JsonCreator
    public PaymentRefund(@JsonProperty(value="id") String id, @JsonProperty(value="amount_money") Money amountMoney, @JsonProperty(value="status") String status, @JsonProperty(value="location_id") String locationId, @JsonProperty(value="app_fee_money") Money appFeeMoney, @JsonProperty(value="processing_fee") List<ProcessingFee> processingFee, @JsonProperty(value="payment_id") String paymentId, @JsonProperty(value="order_id") String orderId, @JsonProperty(value="reason") String reason, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="updated_at") String updatedAt, @JsonProperty(value="team_member_id") String teamMemberId) {
        this.id = id;
        this.status = status;
        this.locationId = locationId;
        this.amountMoney = amountMoney;
        this.appFeeMoney = appFeeMoney;
        this.processingFee = processingFee;
        this.paymentId = paymentId;
        this.orderId = orderId;
        this.reason = reason;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.teamMemberId = teamMemberId;
    }

    @JsonGetter(value="id")
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatus() {
        return this.status;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="amount_money")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonGetter(value="app_fee_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAppFeeMoney() {
        return this.appFeeMoney;
    }

    @JsonGetter(value="processing_fee")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<ProcessingFee> getProcessingFee() {
        return this.processingFee;
    }

    @JsonGetter(value="payment_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaymentId() {
        return this.paymentId;
    }

    @JsonGetter(value="order_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getOrderId() {
        return this.orderId;
    }

    @JsonGetter(value="reason")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getReason() {
        return this.reason;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonGetter(value="team_member_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.status, this.locationId, this.amountMoney, this.appFeeMoney, this.processingFee, this.paymentId, this.orderId, this.reason, this.createdAt, this.updatedAt, this.teamMemberId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PaymentRefund)) {
            return false;
        }
        PaymentRefund other = (PaymentRefund)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.status, other.status) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.amountMoney, other.amountMoney) && Objects.equals(this.appFeeMoney, other.appFeeMoney) && Objects.equals(this.processingFee, other.processingFee) && Objects.equals(this.paymentId, other.paymentId) && Objects.equals(this.orderId, other.orderId) && Objects.equals(this.reason, other.reason) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt) && Objects.equals(this.teamMemberId, other.teamMemberId);
    }

    public String toString() {
        return "PaymentRefund [id=" + this.id + ", amountMoney=" + this.amountMoney + ", status=" + this.status + ", locationId=" + this.locationId + ", appFeeMoney=" + this.appFeeMoney + ", processingFee=" + this.processingFee + ", paymentId=" + this.paymentId + ", orderId=" + this.orderId + ", reason=" + this.reason + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", teamMemberId=" + this.teamMemberId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.id, this.amountMoney).status(this.getStatus()).locationId(this.getLocationId()).appFeeMoney(this.getAppFeeMoney()).processingFee(this.getProcessingFee()).paymentId(this.getPaymentId()).orderId(this.getOrderId()).reason(this.getReason()).createdAt(this.getCreatedAt()).updatedAt(this.getUpdatedAt()).teamMemberId(this.getTeamMemberId());
        return builder;
    }

    public static class Builder {
        private String id;
        private Money amountMoney;
        private String status;
        private String locationId;
        private Money appFeeMoney;
        private List<ProcessingFee> processingFee;
        private String paymentId;
        private String orderId;
        private String reason;
        private String createdAt;
        private String updatedAt;
        private String teamMemberId;

        public Builder(String id, Money amountMoney) {
            this.id = id;
            this.amountMoney = amountMoney;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder appFeeMoney(Money appFeeMoney) {
            this.appFeeMoney = appFeeMoney;
            return this;
        }

        public Builder processingFee(List<ProcessingFee> processingFee) {
            this.processingFee = processingFee;
            return this;
        }

        public Builder paymentId(String paymentId) {
            this.paymentId = paymentId;
            return this;
        }

        public Builder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder teamMemberId(String teamMemberId) {
            this.teamMemberId = teamMemberId;
            return this;
        }

        public PaymentRefund build() {
            return new PaymentRefund(this.id, this.amountMoney, this.status, this.locationId, this.appFeeMoney, this.processingFee, this.paymentId, this.orderId, this.reason, this.createdAt, this.updatedAt, this.teamMemberId);
        }
    }
}

