/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Destination;
import com.squareup.square.models.Money;
import com.squareup.square.models.PayoutFee;
import java.util.List;
import java.util.Objects;

public class Payout {
    private final String id;
    private final String status;
    private final String locationId;
    private final String createdAt;
    private final String updatedAt;
    private final Money amountMoney;
    private final Destination destination;
    private final Integer version;
    private final String type;
    private final List<PayoutFee> payoutFee;
    private final String arrivalDate;

    @JsonCreator
    public Payout(@JsonProperty(value="id") String id, @JsonProperty(value="location_id") String locationId, @JsonProperty(value="status") String status, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="updated_at") String updatedAt, @JsonProperty(value="amount_money") Money amountMoney, @JsonProperty(value="destination") Destination destination, @JsonProperty(value="version") Integer version, @JsonProperty(value="type") String type, @JsonProperty(value="payout_fee") List<PayoutFee> payoutFee, @JsonProperty(value="arrival_date") String arrivalDate) {
        this.id = id;
        this.status = status;
        this.locationId = locationId;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.amountMoney = amountMoney;
        this.destination = destination;
        this.version = version;
        this.type = type;
        this.payoutFee = payoutFee;
        this.arrivalDate = arrivalDate;
    }

    @JsonGetter(value="id")
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatus() {
        return this.status;
    }

    @JsonGetter(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonGetter(value="amount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonGetter(value="destination")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Destination getDestination() {
        return this.destination;
    }

    @JsonGetter(value="version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getVersion() {
        return this.version;
    }

    @JsonGetter(value="type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getType() {
        return this.type;
    }

    @JsonGetter(value="payout_fee")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<PayoutFee> getPayoutFee() {
        return this.payoutFee;
    }

    @JsonGetter(value="arrival_date")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getArrivalDate() {
        return this.arrivalDate;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.status, this.locationId, this.createdAt, this.updatedAt, this.amountMoney, this.destination, this.version, this.type, this.payoutFee, this.arrivalDate);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Payout)) {
            return false;
        }
        Payout other = (Payout)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.status, other.status) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt) && Objects.equals(this.amountMoney, other.amountMoney) && Objects.equals(this.destination, other.destination) && Objects.equals(this.version, other.version) && Objects.equals(this.type, other.type) && Objects.equals(this.payoutFee, other.payoutFee) && Objects.equals(this.arrivalDate, other.arrivalDate);
    }

    public String toString() {
        return "Payout [id=" + this.id + ", locationId=" + this.locationId + ", status=" + this.status + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", amountMoney=" + this.amountMoney + ", destination=" + this.destination + ", version=" + this.version + ", type=" + this.type + ", payoutFee=" + this.payoutFee + ", arrivalDate=" + this.arrivalDate + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.id, this.locationId).status(this.getStatus()).createdAt(this.getCreatedAt()).updatedAt(this.getUpdatedAt()).amountMoney(this.getAmountMoney()).destination(this.getDestination()).version(this.getVersion()).type(this.getType()).payoutFee(this.getPayoutFee()).arrivalDate(this.getArrivalDate());
        return builder;
    }

    public static class Builder {
        private String id;
        private String locationId;
        private String status;
        private String createdAt;
        private String updatedAt;
        private Money amountMoney;
        private Destination destination;
        private Integer version;
        private String type;
        private List<PayoutFee> payoutFee;
        private String arrivalDate;

        public Builder(String id, String locationId) {
            this.id = id;
            this.locationId = locationId;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder destination(Destination destination) {
            this.destination = destination;
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder payoutFee(List<PayoutFee> payoutFee) {
            this.payoutFee = payoutFee;
            return this;
        }

        public Builder arrivalDate(String arrivalDate) {
            this.arrivalDate = arrivalDate;
            return this;
        }

        public Payout build() {
            return new Payout(this.id, this.locationId, this.status, this.createdAt, this.updatedAt, this.amountMoney, this.destination, this.version, this.type, this.payoutFee, this.arrivalDate);
        }
    }
}

