/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class PublishInvoiceRequest {
    private final int version;
    private final String idempotencyKey;

    @JsonCreator
    public PublishInvoiceRequest(@JsonProperty(value="version") int version, @JsonProperty(value="idempotency_key") String idempotencyKey) {
        this.version = version;
        this.idempotencyKey = idempotencyKey;
    }

    @JsonGetter(value="version")
    public int getVersion() {
        return this.version;
    }

    @JsonGetter(value="idempotency_key")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public int hashCode() {
        return Objects.hash(this.version, this.idempotencyKey);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PublishInvoiceRequest)) {
            return false;
        }
        PublishInvoiceRequest other = (PublishInvoiceRequest)obj;
        return Objects.equals(this.version, other.version) && Objects.equals(this.idempotencyKey, other.idempotencyKey);
    }

    public String toString() {
        return "PublishInvoiceRequest [version=" + this.version + ", idempotencyKey=" + this.idempotencyKey + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.version).idempotencyKey(this.getIdempotencyKey());
        return builder;
    }

    public static class Builder {
        private int version;
        private String idempotencyKey;

        public Builder(int version) {
            this.version = version;
        }

        public Builder version(int version) {
            this.version = version;
            return this;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public PublishInvoiceRequest build() {
            return new PublishInvoiceRequest(this.version, this.idempotencyKey);
        }
    }
}

