/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class QuantityRatio {
    private final Integer quantity;
    private final Integer quantityDenominator;

    @JsonCreator
    public QuantityRatio(@JsonProperty(value="quantity") Integer quantity, @JsonProperty(value="quantity_denominator") Integer quantityDenominator) {
        this.quantity = quantity;
        this.quantityDenominator = quantityDenominator;
    }

    @JsonGetter(value="quantity")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getQuantity() {
        return this.quantity;
    }

    @JsonGetter(value="quantity_denominator")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getQuantityDenominator() {
        return this.quantityDenominator;
    }

    public int hashCode() {
        return Objects.hash(this.quantity, this.quantityDenominator);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof QuantityRatio)) {
            return false;
        }
        QuantityRatio other = (QuantityRatio)obj;
        return Objects.equals(this.quantity, other.quantity) && Objects.equals(this.quantityDenominator, other.quantityDenominator);
    }

    public String toString() {
        return "QuantityRatio [quantity=" + this.quantity + ", quantityDenominator=" + this.quantityDenominator + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().quantity(this.getQuantity()).quantityDenominator(this.getQuantityDenominator());
        return builder;
    }

    public static class Builder {
        private Integer quantity;
        private Integer quantityDenominator;

        public Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder quantityDenominator(Integer quantityDenominator) {
            this.quantityDenominator = quantityDenominator;
            return this;
        }

        public QuantityRatio build() {
            return new QuantityRatio(this.quantity, this.quantityDenominator);
        }
    }
}

