/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import java.util.Objects;

public class QuickPay {
    private final String name;
    private final Money priceMoney;
    private final String locationId;

    @JsonCreator
    public QuickPay(@JsonProperty(value="name") String name, @JsonProperty(value="price_money") Money priceMoney, @JsonProperty(value="location_id") String locationId) {
        this.name = name;
        this.priceMoney = priceMoney;
        this.locationId = locationId;
    }

    @JsonGetter(value="name")
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="price_money")
    public Money getPriceMoney() {
        return this.priceMoney;
    }

    @JsonGetter(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.priceMoney, this.locationId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof QuickPay)) {
            return false;
        }
        QuickPay other = (QuickPay)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.priceMoney, other.priceMoney) && Objects.equals(this.locationId, other.locationId);
    }

    public String toString() {
        return "QuickPay [name=" + this.name + ", priceMoney=" + this.priceMoney + ", locationId=" + this.locationId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.name, this.priceMoney, this.locationId);
        return builder;
    }

    public static class Builder {
        private String name;
        private Money priceMoney;
        private String locationId;

        public Builder(String name, Money priceMoney, String locationId) {
            this.name = name;
            this.priceMoney = priceMoney;
            this.locationId = locationId;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder priceMoney(Money priceMoney) {
            this.priceMoney = priceMoney;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public QuickPay build() {
            return new QuickPay(this.name, this.priceMoney, this.locationId);
        }
    }
}

