/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class Range {
    private final String min;
    private final String max;

    @JsonCreator
    public Range(@JsonProperty(value="min") String min, @JsonProperty(value="max") String max) {
        this.min = min;
        this.max = max;
    }

    @JsonGetter(value="min")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getMin() {
        return this.min;
    }

    @JsonGetter(value="max")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getMax() {
        return this.max;
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Range)) {
            return false;
        }
        Range other = (Range)obj;
        return Objects.equals(this.min, other.min) && Objects.equals(this.max, other.max);
    }

    public String toString() {
        return "Range [min=" + this.min + ", max=" + this.max + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().min(this.getMin()).max(this.getMax());
        return builder;
    }

    public static class Builder {
        private String min;
        private String max;

        public Builder min(String min) {
            this.min = min;
            return this;
        }

        public Builder max(String max) {
            this.max = max;
            return this;
        }

        public Range build() {
            return new Range(this.min, this.max);
        }
    }
}

