/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import java.util.Objects;

public class RefundPaymentRequest {
    private final String idempotencyKey;
    private final Money amountMoney;
    private final Money appFeeMoney;
    private final String paymentId;
    private final String reason;
    private final String paymentVersionToken;
    private final String teamMemberId;

    @JsonCreator
    public RefundPaymentRequest(@JsonProperty(value="idempotency_key") String idempotencyKey, @JsonProperty(value="amount_money") Money amountMoney, @JsonProperty(value="app_fee_money") Money appFeeMoney, @JsonProperty(value="payment_id") String paymentId, @JsonProperty(value="reason") String reason, @JsonProperty(value="payment_version_token") String paymentVersionToken, @JsonProperty(value="team_member_id") String teamMemberId) {
        this.idempotencyKey = idempotencyKey;
        this.amountMoney = amountMoney;
        this.appFeeMoney = appFeeMoney;
        this.paymentId = paymentId;
        this.reason = reason;
        this.paymentVersionToken = paymentVersionToken;
        this.teamMemberId = teamMemberId;
    }

    @JsonGetter(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonGetter(value="amount_money")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonGetter(value="app_fee_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAppFeeMoney() {
        return this.appFeeMoney;
    }

    @JsonGetter(value="payment_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaymentId() {
        return this.paymentId;
    }

    @JsonGetter(value="reason")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getReason() {
        return this.reason;
    }

    @JsonGetter(value="payment_version_token")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaymentVersionToken() {
        return this.paymentVersionToken;
    }

    @JsonGetter(value="team_member_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.amountMoney, this.appFeeMoney, this.paymentId, this.reason, this.paymentVersionToken, this.teamMemberId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RefundPaymentRequest)) {
            return false;
        }
        RefundPaymentRequest other = (RefundPaymentRequest)obj;
        return Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.amountMoney, other.amountMoney) && Objects.equals(this.appFeeMoney, other.appFeeMoney) && Objects.equals(this.paymentId, other.paymentId) && Objects.equals(this.reason, other.reason) && Objects.equals(this.paymentVersionToken, other.paymentVersionToken) && Objects.equals(this.teamMemberId, other.teamMemberId);
    }

    public String toString() {
        return "RefundPaymentRequest [idempotencyKey=" + this.idempotencyKey + ", amountMoney=" + this.amountMoney + ", appFeeMoney=" + this.appFeeMoney + ", paymentId=" + this.paymentId + ", reason=" + this.reason + ", paymentVersionToken=" + this.paymentVersionToken + ", teamMemberId=" + this.teamMemberId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.idempotencyKey, this.amountMoney).appFeeMoney(this.getAppFeeMoney()).paymentId(this.getPaymentId()).reason(this.getReason()).paymentVersionToken(this.getPaymentVersionToken()).teamMemberId(this.getTeamMemberId());
        return builder;
    }

    public static class Builder {
        private String idempotencyKey;
        private Money amountMoney;
        private Money appFeeMoney;
        private String paymentId;
        private String reason;
        private String paymentVersionToken;
        private String teamMemberId;

        public Builder(String idempotencyKey, Money amountMoney) {
            this.idempotencyKey = idempotencyKey;
            this.amountMoney = amountMoney;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder appFeeMoney(Money appFeeMoney) {
            this.appFeeMoney = appFeeMoney;
            return this;
        }

        public Builder paymentId(String paymentId) {
            this.paymentId = paymentId;
            return this;
        }

        public Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public Builder paymentVersionToken(String paymentVersionToken) {
            this.paymentVersionToken = paymentVersionToken;
            return this;
        }

        public Builder teamMemberId(String teamMemberId) {
            this.teamMemberId = teamMemberId;
            return this;
        }

        public RefundPaymentRequest build() {
            return new RefundPaymentRequest(this.idempotencyKey, this.amountMoney, this.appFeeMoney, this.paymentId, this.reason, this.paymentVersionToken, this.teamMemberId);
        }
    }
}

