/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class RegisterDomainResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final String status;

    @JsonCreator
    public RegisterDomainResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="status") String status) {
        this.errors = errors;
        this.status = status;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatus() {
        return this.status;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.status);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RegisterDomainResponse)) {
            return false;
        }
        RegisterDomainResponse other = (RegisterDomainResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.status, other.status);
    }

    public String toString() {
        return "RegisterDomainResponse [errors=" + this.errors + ", status=" + this.status + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).status(this.getStatus());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private String status;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public RegisterDomainResponse build() {
            RegisterDomainResponse model = new RegisterDomainResponse(this.errors, this.status);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

