/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class ResumeSubscriptionRequest {
    private final String resumeEffectiveDate;
    private final String resumeChangeTiming;

    @JsonCreator
    public ResumeSubscriptionRequest(@JsonProperty(value="resume_effective_date") String resumeEffectiveDate, @JsonProperty(value="resume_change_timing") String resumeChangeTiming) {
        this.resumeEffectiveDate = resumeEffectiveDate;
        this.resumeChangeTiming = resumeChangeTiming;
    }

    @JsonGetter(value="resume_effective_date")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getResumeEffectiveDate() {
        return this.resumeEffectiveDate;
    }

    @JsonGetter(value="resume_change_timing")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getResumeChangeTiming() {
        return this.resumeChangeTiming;
    }

    public int hashCode() {
        return Objects.hash(this.resumeEffectiveDate, this.resumeChangeTiming);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ResumeSubscriptionRequest)) {
            return false;
        }
        ResumeSubscriptionRequest other = (ResumeSubscriptionRequest)obj;
        return Objects.equals(this.resumeEffectiveDate, other.resumeEffectiveDate) && Objects.equals(this.resumeChangeTiming, other.resumeChangeTiming);
    }

    public String toString() {
        return "ResumeSubscriptionRequest [resumeEffectiveDate=" + this.resumeEffectiveDate + ", resumeChangeTiming=" + this.resumeChangeTiming + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().resumeEffectiveDate(this.getResumeEffectiveDate()).resumeChangeTiming(this.getResumeChangeTiming());
        return builder;
    }

    public static class Builder {
        private String resumeEffectiveDate;
        private String resumeChangeTiming;

        public Builder resumeEffectiveDate(String resumeEffectiveDate) {
            this.resumeEffectiveDate = resumeEffectiveDate;
            return this;
        }

        public Builder resumeChangeTiming(String resumeChangeTiming) {
            this.resumeChangeTiming = resumeChangeTiming;
            return this;
        }

        public ResumeSubscriptionRequest build() {
            return new ResumeSubscriptionRequest(this.resumeEffectiveDate, this.resumeChangeTiming);
        }
    }
}

