/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.BusinessBookingProfile;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class RetrieveBusinessBookingProfileResponse {
    private HttpContext httpContext;
    private final BusinessBookingProfile businessBookingProfile;
    private final List<Error> errors;

    @JsonCreator
    public RetrieveBusinessBookingProfileResponse(@JsonProperty(value="business_booking_profile") BusinessBookingProfile businessBookingProfile, @JsonProperty(value="errors") List<Error> errors) {
        this.businessBookingProfile = businessBookingProfile;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="business_booking_profile")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public BusinessBookingProfile getBusinessBookingProfile() {
        return this.businessBookingProfile;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.businessBookingProfile, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RetrieveBusinessBookingProfileResponse)) {
            return false;
        }
        RetrieveBusinessBookingProfileResponse other = (RetrieveBusinessBookingProfileResponse)obj;
        return Objects.equals(this.businessBookingProfile, other.businessBookingProfile) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "RetrieveBusinessBookingProfileResponse [businessBookingProfile=" + this.businessBookingProfile + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().businessBookingProfile(this.getBusinessBookingProfile()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private BusinessBookingProfile businessBookingProfile;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder businessBookingProfile(BusinessBookingProfile businessBookingProfile) {
            this.businessBookingProfile = businessBookingProfile;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public RetrieveBusinessBookingProfileResponse build() {
            RetrieveBusinessBookingProfileResponse model = new RetrieveBusinessBookingProfileResponse(this.businessBookingProfile, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

