/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class RetrieveCatalogObjectRequest {
    private final Boolean includeRelatedObjects;
    private final Long catalogVersion;

    @JsonCreator
    public RetrieveCatalogObjectRequest(@JsonProperty(value="include_related_objects") Boolean includeRelatedObjects, @JsonProperty(value="catalog_version") Long catalogVersion) {
        this.includeRelatedObjects = includeRelatedObjects;
        this.catalogVersion = catalogVersion;
    }

    @JsonGetter(value="include_related_objects")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getIncludeRelatedObjects() {
        return this.includeRelatedObjects;
    }

    @JsonGetter(value="catalog_version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Long getCatalogVersion() {
        return this.catalogVersion;
    }

    public int hashCode() {
        return Objects.hash(this.includeRelatedObjects, this.catalogVersion);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RetrieveCatalogObjectRequest)) {
            return false;
        }
        RetrieveCatalogObjectRequest other = (RetrieveCatalogObjectRequest)obj;
        return Objects.equals(this.includeRelatedObjects, other.includeRelatedObjects) && Objects.equals(this.catalogVersion, other.catalogVersion);
    }

    public String toString() {
        return "RetrieveCatalogObjectRequest [includeRelatedObjects=" + this.includeRelatedObjects + ", catalogVersion=" + this.catalogVersion + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().includeRelatedObjects(this.getIncludeRelatedObjects()).catalogVersion(this.getCatalogVersion());
        return builder;
    }

    public static class Builder {
        private Boolean includeRelatedObjects;
        private Long catalogVersion;

        public Builder includeRelatedObjects(Boolean includeRelatedObjects) {
            this.includeRelatedObjects = includeRelatedObjects;
            return this;
        }

        public Builder catalogVersion(Long catalogVersion) {
            this.catalogVersion = catalogVersion;
            return this;
        }

        public RetrieveCatalogObjectRequest build() {
            return new RetrieveCatalogObjectRequest(this.includeRelatedObjects, this.catalogVersion);
        }
    }
}

