/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.DisputeEvidence;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class RetrieveDisputeEvidenceResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final DisputeEvidence evidence;

    @JsonCreator
    public RetrieveDisputeEvidenceResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="evidence") DisputeEvidence evidence) {
        this.errors = errors;
        this.evidence = evidence;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="evidence")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public DisputeEvidence getEvidence() {
        return this.evidence;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.evidence);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RetrieveDisputeEvidenceResponse)) {
            return false;
        }
        RetrieveDisputeEvidenceResponse other = (RetrieveDisputeEvidenceResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.evidence, other.evidence);
    }

    public String toString() {
        return "RetrieveDisputeEvidenceResponse [errors=" + this.errors + ", evidence=" + this.evidence + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).evidence(this.getEvidence());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private DisputeEvidence evidence;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder evidence(DisputeEvidence evidence) {
            this.evidence = evidence;
            return this;
        }

        public RetrieveDisputeEvidenceResponse build() {
            RetrieveDisputeEvidenceResponse model = new RetrieveDisputeEvidenceResponse(this.errors, this.evidence);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

