/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.GiftCard;
import java.util.List;
import java.util.Objects;

public class RetrieveGiftCardResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final GiftCard giftCard;

    @JsonCreator
    public RetrieveGiftCardResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="gift_card") GiftCard giftCard) {
        this.errors = errors;
        this.giftCard = giftCard;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="gift_card")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public GiftCard getGiftCard() {
        return this.giftCard;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.giftCard);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RetrieveGiftCardResponse)) {
            return false;
        }
        RetrieveGiftCardResponse other = (RetrieveGiftCardResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.giftCard, other.giftCard);
    }

    public String toString() {
        return "RetrieveGiftCardResponse [errors=" + this.errors + ", giftCard=" + this.giftCard + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).giftCard(this.getGiftCard());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private GiftCard giftCard;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder giftCard(GiftCard giftCard) {
            this.giftCard = giftCard;
            return this;
        }

        public RetrieveGiftCardResponse build() {
            RetrieveGiftCardResponse model = new RetrieveGiftCardResponse(this.errors, this.giftCard);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

