/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class RetrieveInventoryChangesRequest {
    private final String locationIds;
    private final String cursor;

    @JsonCreator
    public RetrieveInventoryChangesRequest(@JsonProperty(value="location_ids") String locationIds, @JsonProperty(value="cursor") String cursor) {
        this.locationIds = locationIds;
        this.cursor = cursor;
    }

    @JsonGetter(value="location_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLocationIds() {
        return this.locationIds;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(this.locationIds, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RetrieveInventoryChangesRequest)) {
            return false;
        }
        RetrieveInventoryChangesRequest other = (RetrieveInventoryChangesRequest)obj;
        return Objects.equals(this.locationIds, other.locationIds) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "RetrieveInventoryChangesRequest [locationIds=" + this.locationIds + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().locationIds(this.getLocationIds()).cursor(this.getCursor());
        return builder;
    }

    public static class Builder {
        private String locationIds;
        private String cursor;

        public Builder locationIds(String locationIds) {
            this.locationIds = locationIds;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public RetrieveInventoryChangesRequest build() {
            return new RetrieveInventoryChangesRequest(this.locationIds, this.cursor);
        }
    }
}

